package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.List;
import java.util.Map;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.*;
import cn.com.duiba.wolf.dubbo.DubboResult;

@AdvancedFeignClient
public interface RemoteTuiaActivityService {

    /**
     * 获取活动定向的媒体
     *
     * @param activityId
     * @param source
     * @return 媒体列表
     */
    DubboResult<List<MediaAppDto>> getActivityDirectedMediaApp(Long activityId, Integer source);

    //广告调用
    /**
     * 查询活动关联广告，给引擎提供的接口
     * 
     * @param activityId 活动ID
     * @param source 活动来源
     * @return 广告ID列表
     */
    DubboResult<List<Long>> getActivityAdvertIds(Long activityId, Integer source);

    //广告调用
    /**
     * 获取活动明细，只带基本信息，给引擎提供的接口
     *
     * @param activityId
     * @param source 活动来源
     * @param actTypeMap 活动类型对应名称
     * @return 活动明细
     */
    DubboResult<RspActivityDto> getActivityPlan(Long activityId, Integer source,Map<Integer, String> actTypeMap);


    /**
     * 查询某个活动在某个广告位下的SPM值
     *
     * @param slotId 广告位ID
     * @param statType 统计维度
     * @return 活动SPM
     */
    DubboResult<List<ActivitySpmDto>> getSlotSpm(Long slotId, Integer statType);

    /**
     * 将活动从试投列表中移除
     *
     * @param activityId 活动ID
     * @param source 活动来源
     * @return Boolean
     */
    DubboResult<Boolean> removeFromNewActList(Long activityId, Integer source);
    
    /**
     * 获取活动计划明细
     *
     * @param activityId 活动ID
     * @param source 活动来源
     * @return 活动计划
     */
    DubboResult<RspActivityDto> getActivityPlanDetail(Long activityId, Integer source, Map<Integer, String> actTypeMap);

    /**
     * 按每UV发券(全局维度)大小返回活动，会按照广告位屏蔽标签进行过滤
     * @param slotId
     * @return
     */
    DubboResult<List<Long>> getActivityByUVLaunch(Long slotId);
    
    /**
     * 查询广告的Rpm
     *
     * @author guyan
     * @param slotId
     * @param statType
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<ActivityRpmDto>> getSlotRpm(Long slotId, Integer statType);

	/**
	 * 根据actIds和活动type、source查询定向到该媒体的活动
	 * 如果根据活动id集合为空或查不到活动则返回根据type、source查询到的活动推广计划集合按照id倒序后的前20条
	 * @author sjx
	 * @param actIds 活动id集合，可以为空
	 * @param type 活动类型 不能为空 
	 * @param souce 活动来源：（0：兑吧商业活动，1：推啊商业活动，2：流量引导页）
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<List<ActivityDto>> getActByTypeAndSource(List<Long> actIds,Integer type,Integer souce);
	
	/**
	 * getSlotRpmInWeek: 获取广告位一周内活动rpm数据 <br/>
	 *
	 * @author Administrator
	 * @param slotId
	 * @param statType
	 * @return
	 * @since JDK 1.6
	 */
	public DubboResult<List<ActivityRpmDto>> getSlotRpmInWeek(Long slotId, Integer statType);

	/**
	 * 获取广告位一周内活动rpm数据（包含主会场）
	 *
	 * @param slotId   广告位
	 * @param statType 维度
	 * @return
	 */
	List<ActivityRpmWithMainMeetDto> getSlotRpmWithMainMeetInWeek(Long slotId, Integer statType);
	
	/**
	 * getSlotRpmInWeek4manual:获取广告位一周内活动rpm数据(手投专用). <br/>
	 *
	 * @author Administrator
	 * @param slotId
	 * @param statType
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<List<ActivityRpmDto>> getSlotRpmInWeek4manual(Long slotId, Integer statType) ;

	RspMaterialSpecificationDto  getRspMaterialSpecificationDto(Long msId);

	/**
	 * 获取广告位下指定规格的过滤后的 素材列表
	 * @param msId
	 * @param slotId
	 * @return
	 */
	RspMaterialSpecificationDto getRspFilteredMaterialSpecificationDto(Long msId, Long slotId);

	/**
	 * 获取默认活动计划的素材（根据广告位筛选素材列表）
	 * @param activityId
	 * @param activitySource
	 * @param slotId
	 * @return
	 */
	RspMaterialSpecificationDto getRspMaterialSpecificationDtoByActivity(Long activityId, Integer activitySource, Long slotId);

	Map getActivityDto(Long activityId,Integer type);
}
