package cn.com.duiba.tuia.ssp.center.api.remote.sdk;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.BaseQueryDto;
import cn.com.duiba.tuia.ssp.center.api.dto.PageDto;
import cn.com.duiba.tuia.ssp.center.api.dto.sdk.TuiaSDKPluginDTO;

import java.util.List;

@AdvancedFeignClient
public interface RemoteTuiaPluginService {

    List<TuiaSDKPluginDTO> listPluginByPage(BaseQueryDto baseQueryDto);

    List<TuiaSDKPluginDTO> listByVersionCodes(List<Long> versionCodes);

    List<TuiaSDKPluginDTO> listAll();

    PageDto<TuiaSDKPluginDTO> listByPage(BaseQueryDto baseQueryDto);

    TuiaSDKPluginDTO getById(Long id);

    TuiaSDKPluginDTO getByVersionCode(Long versionCode);

    Boolean insertPlugin(TuiaSDKPluginDTO tuiaSDKPluginDTO);

    Boolean updatePlugin(TuiaSDKPluginDTO tuiaSDKPluginDTO);

    Boolean savePlugin(TuiaSDKPluginDTO tuiaSDKPluginDTO);

    Boolean deletePluginByVersionCode(Long versionCode);

    Boolean deletePluginById(Long id);
}
