/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.ssp.center.api.tool;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateUtil.class);

    public static List<String> getBetweenDate(String startDateStr, String endDateStr) {
        try {
            DateTimeFormatter pattern = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            LocalDate startDate = LocalDate.parse(startDateStr, pattern);
            LocalDate endDate = LocalDate.parse(endDateStr, pattern);
            ArrayList<String> result = new ArrayList<String>();
            while (startDate.compareTo(endDate) <= 0) {
                result.add(startDate.format(pattern));
                startDate = startDate.plusDays(1L);
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.error("\u65e5\u671f\u89e3\u6790\u5f02\u5e38\uff0cstartDate:" + startDateStr + ", endDate:" + endDateStr, (Throwable)e);
            return Collections.emptyList();
        }
    }

    public static String YYYY_MM_DD(LocalDate date) {
        return DateUtil.YYYY_MM_DD(date, 0);
    }

    public static String YYYY_MM_DD(LocalDate date, int add) {
        String pattern = "yyyy-MM-dd";
        return DateUtil.getDateString(date, add, pattern);
    }

    public static String YYYYMMDD(LocalDate date) {
        return DateUtil.YYYYMMDD(date, 0);
    }

    public static String YYYYMMDD(LocalDate date, int add) {
        String pattern = "yyyyMMdd";
        return DateUtil.getDateString(date, add, pattern);
    }

    private static String getDateString(LocalDate date, int add, String pattern) {
        return date.plusDays(add).format(DateTimeFormatter.ofPattern(pattern));
    }
}

