package cn.com.duiba.tuia.ssp.center.api.dto.prePayInvoiceRecord;

import java.io.Serializable;

/**
* 预付款发票纪录表
*/
public class PrePayInvoiceRecordDto implements Serializable {

    private static final long serialVersionUID = 8222300069764460482L;

    /**
     * The id.
     */
    protected Long id;

    /**
     * 创建时间.
     */
    protected String gmtCreate;

    /**
    * 媒体用户ID
    */
    private Long mediaId;

    /**
    * 操作人员ID
    */
    private Long managerId;

    /**
     * 操作人姓名
     */
    private String managerName;

    /**
    * 开户名称
    */
    private String openAccount;

    /**
    * 开票方式：0-消耗 1-打款
    */
    private Integer invoiceWay;

    /**
    * 开票主体：0-杭州 1-霍尔果斯 2-霍城兑捷
    */
    private Integer invoiceBody;

    /**
    * 发票金额
    */
    private Long invoiceAmount;

    /**
    * 发票编号
    */
    private String invoiceNumber;

    /**
    * 请款日期(yyyy-MM-dd)
    */
    private String paymentDate;

    /**
    * 打款日期(yyyy-MM-dd)
    */
    private String payDate;

    /**
    * 发票收到日期(yyyy-MM-dd)
    */
    private String invoiceReceiveDate;

    /**
    * 发票状态：0-媒介助理 1-已提交财务
    */
    private Integer invoiceStatus;

    /**
    * 提交财务日期
    */
    private String submitFinanceDate;

    /**
    * 备注
    */
    private String remark;

    /**
     * 预付款订单ID
     */
    private Long prePayOrderId;


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setManagerId(Long managerId) {
        this.managerId = managerId;
    }

    public Long getManagerId() {
        return managerId;
    }

    public void setOpenAccount(String openAccount) {
        this.openAccount = openAccount;
    }

    public String getOpenAccount() {
        return openAccount;
    }

    public void setInvoiceWay(Integer invoiceWay) {
        this.invoiceWay = invoiceWay;
    }

    public Integer getInvoiceWay() {
        return invoiceWay;
    }

    public void setInvoiceBody(Integer invoiceBody) {
        this.invoiceBody = invoiceBody;
    }

    public Integer getInvoiceBody() {
        return invoiceBody;
    }

    public void setInvoiceAmount(Long invoiceAmount) {
        this.invoiceAmount = invoiceAmount;
    }

    public Long getInvoiceAmount() {
        return invoiceAmount;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public String getInvoiceNumber() {
        return invoiceNumber;
    }

    public void setPaymentDate(String paymentDate) {
        this.paymentDate = paymentDate;
    }

    public String getPaymentDate() {
        return paymentDate;
    }

    public void setPayDate(String payDate) {
        this.payDate = payDate;
    }

    public String getPayDate() {
        return payDate;
    }

    public void setInvoiceReceiveDate(String invoiceReceiveDate) {
        this.invoiceReceiveDate = invoiceReceiveDate;
    }

    public String getInvoiceReceiveDate() {
        return invoiceReceiveDate;
    }

    public void setInvoiceStatus(Integer invoiceStatus) {
        this.invoiceStatus = invoiceStatus;
    }

    public Integer getInvoiceStatus() {
        return invoiceStatus;
    }

    public void setSubmitFinanceDate(String submitFinanceDate) {
        this.submitFinanceDate = submitFinanceDate;
    }

    public String getSubmitFinanceDate() {
        return submitFinanceDate;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getRemark() {
        return remark;
    }

    public String getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(String gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public String getManagerName() {
        return managerName;
    }

    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }

    public Long getPrePayOrderId() {
        return prePayOrderId;
    }

    public void setPrePayOrderId(Long prePayOrderId) {
        this.prePayOrderId = prePayOrderId;
    }

    @Override
    public String toString() {
        return "PrePayInvoiceRecordDto{" +
                "id=" + id +
                ", gmtCreate='" + gmtCreate + '\'' +
                ", mediaId=" + mediaId +
                ", managerId=" + managerId +
                ", managerName='" + managerName + '\'' +
                ", openAccount='" + openAccount + '\'' +
                ", invoiceWay=" + invoiceWay +
                ", invoiceBody=" + invoiceBody +
                ", invoiceAmount=" + invoiceAmount +
                ", invoiceNumber='" + invoiceNumber + '\'' +
                ", paymentDate='" + paymentDate + '\'' +
                ", payDate='" + payDate + '\'' +
                ", invoiceReceiveDate='" + invoiceReceiveDate + '\'' +
                ", invoiceStatus=" + invoiceStatus +
                ", submitFinanceDate='" + submitFinanceDate + '\'' +
                ", remark='" + remark + '\'' +
                ", prePayOrderId=" + prePayOrderId +
                '}';
    }
}

