package cn.com.duiba.tuia.ssp.center.api.econtract.util;

import java.util.Objects;

/**
 * 〈一句话功能简述〉<br>
 * Description: 电子合同常量工具对象
 *
 * @author hillchen
 * @create 2019/1/23 10:41
 */
public class EcontractConstant {
    private EcontractConstant(){}

    /**
     * 实名认证审核结果常量
     * 1：审核通过
     * 2：审核拒绝
     */
    public enum AuditResult{
        AUDIT_RESULT_SUCC(1,"审核通过"),
        AUDIT_RESULT_FAIL(2,"审核拒绝")
        ;
        private String desc;
        private int result;

        AuditResult(int result, String desc) {
            this.desc = desc;
            this.result = result;
        }


        public String getDesc() {
            return desc;
        }

        public int getResult() {
            return result;
        }

        /**
         * 是否审核通过
         * @param result
         * @return
         */
        public static boolean auditSucc(Integer result){
            return sameResult(AUDIT_RESULT_SUCC,result);
        }

        /**
         * 是否为相同审核结果
         * @param auditResult
         * @param result
         * @return
         */
        public static boolean sameResult(AuditResult auditResult,Integer result){
            return auditResult != null && auditResult.sameResult(result);
        }

        /**
         * 是否为相同审核结果
         * @param result
         * @return
         */
        public boolean sameResult(Integer result){
            return Objects.equals(this.result,result);
        }
    }

    /**
     * 实名认证审核拒绝类型:
     * 0:没有异常
     * 1:手持身份证照片与填写信息不一致
     * 2:授权证明信息有误
     */
    public enum AuditRefuseType{
        SUCC(0,"审核通过"),
        PROCURAtOR_ERROR(1,"手持身份证照片与填写信息不一致"),
        POWER_ATTONEY_ERROR(2,"授权证明信息有误")
        ;
        private String desc;
        private int type;

        AuditRefuseType(int type, String desc) {
            this.desc = desc;
            this.type = type;
        }


        public String getDesc() {
            return desc;
        }

        public int getType() {
            return type;
        }


        /**
         * 是否为相同拒绝原因
         * @param refuseType
         * @return
         */
        public  boolean sameType( Integer refuseType){
            return  Objects.equals(this.type,refuseType);
        }

        public static String getRefuseMsg(Integer refuseType){
            for(AuditRefuseType auditRefuseType : AuditRefuseType.values()) {
                if(auditRefuseType.sameType(refuseType)){
                    return auditRefuseType.desc;
                }
            }
            return "";
        }
    }

    /**
     * 实名认证资料提交审核结果：
     * 0:资料校验通过进入下一步人工审核
     * 1:资料校验通过等待输入验证码
     * 2:代理人三要素认证不通过补充身份证照片
     * 3:资料校验不通过需要重填
     */
    public enum RealnameSubmitResult{
        SUBMIT_RESULT_SUCC(0,"资料校验通过进入下一步人工审核"),
        SUBMIT_RESULT_VCODE(1,"资料校验通过等待输入验证码"),
        SUBMIT_RESULT_IMG(2,"代理人三要素认证不通过补充身份证照片"),
        SUBMIT_RESULT_FAIL(3,"资料校验不通过需要重填"),;

        private int result;
        private String desc;

        RealnameSubmitResult(int result,String desc) {
            this.desc = desc;
            this.result = result;
        }

        public String getDesc() {
            return desc;
        }

        public int getResult() {
            return result;
        }

        public  boolean sameResult( Integer result){
            return  Objects.equals(this.result,result);
        }
        /**
         * 是否为相同拒绝原因
         * @param realnameSubmitResult
         * @param result
         * @return
         */
        public static boolean sameResult(RealnameSubmitResult realnameSubmitResult, Integer result){
            return realnameSubmitResult != null && realnameSubmitResult.sameResult(result);
        }
    }

    /**
     * 实名认证状态：
     * 0：未认证
     * 1：待上传手持身份证照
     * 2：认证中:人工审核中
     * 3：打款认证中
     * 4：认证成功
     * 5：认证失败
     */
    public enum RealnameStatus{
        REALNAME_STATUS_UNCERTIFIED(0,"未认证"),
        REALNAME_STATUS_TOUPIMG(1,"待上传手持身份证照"),
        REALNAME_STATUS_TOAUDIT(2,"认证中:人工审核中"),
        REALNAME_STATUS_TOPAY(3,"打款认证中"),
        REALNAME_STATUS_SUCC(4,"认证成功"),
        REALNAME_STATUS_FAIL(5,"认证失败");
        private int status;
        private String desc;

        RealnameStatus(int status, String desc) {
            this.status = status;
            this.desc = desc;
        }

        public int getStatus() {
            return status;
        }

        public String getDesc() {
            return desc;
        }

        public boolean sameStatus(Integer realnameStatus){
            return Objects.equals(status,realnameStatus);
        }
    }

    /**
     * 代理人验证通过类型：
     * 0:个人三要素实名认证
     * 1:个人二要素加人工审核认证
     */
    public enum ProcuratorCheckType{
        CHECK_TYPE_THREE_ELEMENT(0,"个人三要素实名认证"),
        CHECK_TYPE_TOW_ELEMENT(1,"个人二要素加人工审核认证");
        private int type;
        private String desc;

        ProcuratorCheckType(int type, String desc) {
            this.type = type;
            this.desc = desc;
        }

        public int getType() {
            return type;
        }

        public String getDesc() {
            return desc;
        }
    }

    /**
     * 代理人验证通过类型：
     * 0:未认证
     * 1:验证通过
     * 2:验证失败
     */
    public enum PayAuthResult{
        PAY_AUTH_RESULT_UNCERTIFIED(0,"未认证"),
        PAY_AUTH_RESULT_SUCC(1,"验证通过"),
        PAY_AUTH_RESULT_FAIL(2,"验证失败");
        private int result;
        private String desc;

        PayAuthResult(int result, String desc) {
            this.result = result;
            this.desc = desc;
        }

        public int getResult() {
            return result;
        }

        public String getDesc() {
            return desc;
        }
    }

    /**
     * 合同类型：
     * 0:杭州主体合同
     * 1：霍尔果斯主体合同
     */
    public enum ContractType{
        CONTRACT_TYPE_HZ(0,"杭州主体合同"),
        CONTRACT_TYPE_HEGS(1,"霍尔果斯主体合同");
        private int type;
        private String desc;

        ContractType(int type, String desc) {
            this.type = type;
            this.desc = desc;
        }

        public int getType() {
            return type;
        }

        public String getDesc() {
            return desc;
        }

        public boolean sameType(Integer contractType){
            return Objects.equals(type,contractType);
        }
    }

    /**
     * 合同状态：
     * 0:未生成
     * 1：待签署
     * 2：签署完成
     */
    public enum ContractStatus{
        CONTRACT_STATUS_UNCREATE(0,"未生成"),
        CONTRACT_STATUS_UNSIGN(1,"待签署"),
        CONTRACT_STATUS_SIGNED(2,"签署完成"),;
        private int status;
        private String desc;

        ContractStatus(int status, String desc) {
            this.status = status;
            this.desc = desc;
        }

        public int getStatus() {
            return status;
        }

        public String getDesc() {
            return desc;
        }

        public boolean sameStatus(Integer contractStatus){
            return Objects.equals(contractStatus,status);
        }
    }
    /**
     * 自主化用户状态：
     * 0：未认证；
     * 1：财务资质认证通过；
     * 2：授权代理人认证通过；
     * 3：打款认证通过；
     * 4：合同签署。
     */
    public enum AutonomyStatus{
        AUTONOMY_STATUS_UNCERTIFIED(0,"未认证"),
        AUTONOMY_STATUS_FINANCE(1,"财务资质认证通过"),
        AUTONOMY_STATUS_PROCURATOR(2,"授权代理人认证通过"),
        AUTONOMY_STATUS_PAYAUTH(3,"打款认证通过"),
        AUTONOMY_STATUS_SIGN(4,"合同签署");

        private int status;
        private String desc;

        AutonomyStatus(int status, String desc) {
            this.status = status;
            this.desc = desc;
        }

        public int getStatus() {
            return status;
        }

        public String getDesc() {
            return desc;
        }

        public boolean sameStatus(Integer status){
            return Objects.equals(status,this.status);
        }

        public static String getStatusStr(Integer status){
            if(status == null){
                return "";
            }
            for(AutonomyStatus autonomyStatus : AutonomyStatus.values()){
                if(autonomyStatus.sameStatus(status)){
                    return autonomyStatus.desc;
                }
            }
            return "";
        }
    }
}