
package cn.com.duiba.tuia.ssp.center.api.dto;
import org.apache.commons.lang3.ObjectUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class PrePayDto implements Serializable {

    /** 拒绝 */
    public static final int   REJECT_STATUS             = 0;
    /** 媒体运营审核 */
    public static final int   OPERATION_CHECK           = 1;
    /** 风控审核 */
    public static final int   RISK_CHECK                = 2;
    /** 媒体负责人审核 */
    public static final int   MEDIA_CHARGE_MAN_CHECK    = 3;
    /** 媒介负责人审核 */
    public static final int   MEDIUM_CHARGE_MAN_CHECK   = 4;
    /** 总裁审核 */
    public static final int   PRESIDENT_CHECK           = 5;
    /** 打款审核 */
    public static final int   REMIT_CHECK               = 6;
    /** 已打款 */
    public static final int   WITHDRAW_DEPOSIT          = 7;
    /** 已打款(已抵扣) */
    public static final int   WITHDRAW_DEPOSIT_DEDUCTED = 8;
    /** 已退款 */
    public static final int   REFUND                    = 9;
    /** 已退款(已抵扣) */
    public static final int   REFUND_DEDUCTED           = 10;

    private static final long serialVersionUID          = 1468732344078793L;

    private Long              id;

    private Long              mediaId;

    private String            email;

    private String            appName;

    private Long              appId;

    private Long              prePayOrderId;

    private String            cardNumber;

    private String            bankName;

    private String            province;

    private String            city;

    private String            branchName;

    private Long              prePayAmount;

    private Integer           prePayStatus;

    private Integer           rejectStatus;

    private String            rejectReason;

    private Boolean           firstPrePay;

    private Date              gmtCreate;

    private Date              gmtModified;

    private String            openAccount;

    private Long              cashOrderId;

    private Date              curDate;

    private String            payImg;

    private int               receiveStatus;//请款单 0:未收到 1:已收到

    private String            remark;

    private Long              hzAmount;//杭州预付款

    private Long              hegsAmount;//霍尔果斯预付款

    private Long              hcdjAmount;//霍城兑捷预付款

    private Long              hzRemainAmount;//杭州冲抵后剩余金额

    private Long              hegsRemainAmount;//霍尔果斯冲抵后剩余金额

    private Long              hcdjRemainAmount;//霍城兑捷冲抵后剩余金额

    private Integer           mediumAnomalyFlag; //媒介异常标识:1-异常 0-非异常

    private Integer           mediaAnomalyFlag; //媒体异常标识:1-异常 0-非异常

    private String            mediumName; //媒介

    private String            operationName; //运营


    public String getMediumName() {
        return mediumName;
    }

    public void setMediumName(String mediumName) {
        this.mediumName = mediumName;
    }

    public Boolean getFirstPrePay() {
        return firstPrePay;
    }

    public void setFirstPrePay(Boolean firstPrePay) {
        this.firstPrePay = firstPrePay;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getPrePayOrderId() {
        return prePayOrderId;
    }

    public void setPrePayOrderId(Long prePayOrderId) {
        this.prePayOrderId = prePayOrderId;
    }

    public String getCardNumber() {
        return cardNumber;
    }

    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getBranchName() {
        return branchName;
    }

    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    public Long getPrePayAmount() {
        return prePayAmount;
    }

    public void setPrePayAmount(Long prePayAmount) {
        this.prePayAmount = prePayAmount;
    }

    public Integer getPrePayStatus() {
        return prePayStatus;
    }

    public void setPrePayStatus(Integer prePayStatus) {
        this.prePayStatus = prePayStatus;
    }

    public Integer getRejectStatus() {
        return rejectStatus;
    }

    public void setRejectStatus(Integer rejectStatus) {
        this.rejectStatus = rejectStatus;
    }

    public String getRejectReason() {
        return rejectReason;
    }

    public void setRejectReason(String rejectReason) {
        this.rejectReason = rejectReason;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getOpenAccount() {
        return openAccount;
    }

    public void setOpenAccount(String openAccount) {
        this.openAccount = openAccount;
    }

    public Long getCashOrderId() {
        return cashOrderId;
    }

    public void setCashOrderId(Long cashOrderId) {
        this.cashOrderId = cashOrderId;
    }

    public Date getCurDate() {
        return curDate;
    }

    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    public String getPayImg() {
        return payImg;
    }

    public void setPayImg(String payImg) {
        this.payImg = payImg;
    }

    public int getReceiveStatus() {
        return receiveStatus;
    }

    public void setReceiveStatus(int receiveStatus) {
        this.receiveStatus = receiveStatus;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getHzAmount() {
        return hzAmount;
    }

    public void setHzAmount(Long hzAmount) {
        this.hzAmount = hzAmount;
    }

    public Long getHegsAmount() {
        return hegsAmount;
    }

    public void setHegsAmount(Long hegsAmount) {
        this.hegsAmount = hegsAmount;
    }

    public Long getHzRemainAmount() {
        return hzRemainAmount;
    }

    public void setHzRemainAmount(Long hzRemainAmount) {
        this.hzRemainAmount = hzRemainAmount;
    }

    public Long getHegsRemainAmount() {
        return hegsRemainAmount;
    }

    public void setHegsRemainAmount(Long hegsRemainAmount) {
        this.hegsRemainAmount = hegsRemainAmount;
    }

    public Long getHcdjAmount() {
        return hcdjAmount;
    }

    public void setHcdjAmount(Long hcdjAmount) {
        this.hcdjAmount = hcdjAmount;
    }

    public Long getHcdjRemainAmount() {
        return hcdjRemainAmount;
    }

    public void setHcdjRemainAmount(Long hcdjRemainAmount) {
        this.hcdjRemainAmount = hcdjRemainAmount;
    }

    public Integer getMediumAnomalyFlag() {
        return mediumAnomalyFlag;
    }

    public void setMediumAnomalyFlag(Integer mediumAnomalyFlag) {
        this.mediumAnomalyFlag = mediumAnomalyFlag;
    }

    public Integer getMediaAnomalyFlag() {
        return mediaAnomalyFlag;
    }

    public void setMediaAnomalyFlag(Integer mediaAnomalyFlag) {
        this.mediaAnomalyFlag = mediaAnomalyFlag;
    }

    public Long getAmount(){
        if(Objects.equals(this.getPrePayStatus(),PrePayDto.REFUND) || Objects.equals(this.getPrePayStatus(),PrePayDto.REFUND_DEDUCTED)){
            return ObjectUtils.defaultIfNull(this.getPrePayAmount(),0L) *-1;
        } else {
            return ObjectUtils.defaultIfNull(this.getPrePayAmount(),0L);
        }
    }

    public Long getHzAmountValue(){
        if(Objects.equals(this.getPrePayStatus(),PrePayDto.REFUND) || Objects.equals(this.getPrePayStatus(),PrePayDto.REFUND_DEDUCTED)){
            return ObjectUtils.defaultIfNull(this.getHzAmount(),0L) *-1;
        } else {
            return ObjectUtils.defaultIfNull(this.getHzAmount(),0L);
        }
    }

    public Long getHegsAmountValue(){
        if(Objects.equals(this.getPrePayStatus(),PrePayDto.REFUND) || Objects.equals(this.getPrePayStatus(),PrePayDto.REFUND_DEDUCTED)){
            return ObjectUtils.defaultIfNull(this.getHegsAmount(),0L) *-1;
        } else {
            return ObjectUtils.defaultIfNull(this.getHegsAmount(),0L);
        }
    }

    public Long getHcdjAmountValue(){
        if(Objects.equals(this.getPrePayStatus(),PrePayDto.REFUND) || Objects.equals(this.getPrePayStatus(),PrePayDto.REFUND_DEDUCTED)){
            return ObjectUtils.defaultIfNull(this.getHcdjAmount(),0L) *-1;
        } else {
            return ObjectUtils.defaultIfNull(this.getHcdjAmount(),0L);
        }
    }

    public Long getHzRemainAmountValue(){
        if(Objects.equals(this.getPrePayStatus(),PrePayDto.REFUND) || Objects.equals(this.getPrePayStatus(),PrePayDto.REFUND_DEDUCTED)){
            return ObjectUtils.defaultIfNull(this.getHzRemainAmount(),0L) *-1;
        } else {
            return ObjectUtils.defaultIfNull(this.getHzRemainAmount(),0L);
        }
    }

    public Long getHegsRemainAmountValue(){
        if(Objects.equals(this.getPrePayStatus(),PrePayDto.REFUND) || Objects.equals(this.getPrePayStatus(),PrePayDto.REFUND_DEDUCTED)){
            return ObjectUtils.defaultIfNull(this.getHegsRemainAmount(),0L) *-1;
        } else {
            return ObjectUtils.defaultIfNull(this.getHegsRemainAmount(),0L);
        }
    }

    public Long getHcdjRemainAmountValue(){
        if(Objects.equals(this.getPrePayStatus(),PrePayDto.REFUND) || Objects.equals(this.getPrePayStatus(),PrePayDto.REFUND_DEDUCTED)){
            return ObjectUtils.defaultIfNull(this.getHcdjRemainAmount(),0L) *-1;
        } else {
            return ObjectUtils.defaultIfNull(this.getHcdjRemainAmount(),0L);
        }
    }

    public String getOperationName() {
        return operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }
}
