package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.NewAppWaveInfo;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqPageQuery;

import java.util.List;

/**
 * @author fangzhipeng
 * @date 2018/10/15
 */
@AdvancedFeignClient
public interface RemoteNewAppWaveService {

    /**
     * 新媒体分页列表查询
     * @param req
     * @return
     */
    PageResultDto<NewAppWaveInfo> pageList(ReqPageQuery req);

    /**
     * 返回新媒体列表
     * @return
     */
    List<NewAppWaveInfo> getList();

    /**
     * 新媒体流量打标
     * @param id 记录id
     * @param appMark 流量质量标记 -1-未打标状态 1-优质流量 2-一般流量
     * @return
     */
    int markApp(Long id, Integer appMark);

}
