/**
 * 
 */
package cn.com.duiba.tuia.ssp.center.api.dto;

import cn.com.duiba.tuia.ssp.center.api.query.Sort;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 此类描述的是： 分页查询条件
 * 
 * @author: leiliang
 * @version: 2016年2月18日 上午9:48:22
 */
@Data
public class BaseQueryDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /** 每页10条记录. */
    public static final int   PAGE_SIZE_10     = 10;

    /** 每页20条记录. */
    public static final int   PAGE_SIZE_20     = 20;

    /** 每页50条记录. */
    public static final int   PAGE_SIZE_50     = 50;

    /** 最大每页记录数(10000条). */
    public static final int   PAGE_SIZE_MAX    = 10000;

    /** 起始记录数. */
    private int               rowStart         = 0;

    /** 当前页. */
    private int               currentPage      = 1;

    /** 每页记录数， 为-1时代表查询所有. */
    private Integer           pageSize;

    /** 排序字段. */
    private String            sort;

    /**
     * 支持多个排序
     */
    private List<Sort> sorts;

    /** 排序方式：(升序:asc,降序：desc)默认降序. */
    private String            order;
    
    /**总计查询*/
    public static final int TOTAL_QUERY=1;
    
    /** 管理员ID，数据权限使用*/
    @ApiModelProperty(value = "管理员ID", required = false)
    private Long            managerId;
    
    /** 管理员能查看的app列表*/
    @ApiModelProperty(value = "管理员ID", required = false)
    private List<Long>      managerAppIds;

    /** 管理员能查看的用户列表*/
    @ApiModelProperty(value = "用户ID集合", required = false)
    private List<Long>      managerMediaIds;
    
    /**总计查询*/
    @ApiModelProperty(value = "总计查询", required = false)
    private Integer         totalQuery;

    /**
     * 是否可查询
     */
    private  boolean        isQuery;

    /**
     *是否拥有超级权限
     */
    private  boolean        isSuperPermission;

    /**
     * 新增排序字段
     * @param column 列名
     * @param sortType 排序方式
     */
    public void addOrderBy(String column, Sort.SortType sortType) {
        if(column == null || column.trim().length() == 0){
            throw new IllegalArgumentException("列名不能为空");
        }
        if(sortType == null){
            throw new IllegalArgumentException("排序方式不能为空");
        }
        if(sorts == null){
            sorts = new ArrayList<Sort>(2);
        }
        //防止注入
        column = column.replaceAll(";", "");
        this.sorts.add(new Sort(column, sortType));
    }

    public boolean isQuery(List<Long> ids) {
        return this.isSuperPermission || !CollectionUtils.isEmpty(ids);
    }

    /**
     * 校验分页信息
     */
    public void checkPageParam() {
        if (getPageSize() == null) {
            this.setPageSize(BaseQueryDto.PAGE_SIZE_20);
        }
    }

}
