package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.duiba.tuia.ssp.center.api.dto.MediaTagDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqUpdateMediaUserPortraitTagDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqUpdateRiskMediaTagDto;
import cn.com.duiba.tuia.ssp.center.api.dto.TagLibraryDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Set;

@AdvancedFeignClient
public interface RemoteMediaTagService {

	//添加标签（一级或者二级标签）,返回id
	DubboResult<Long> insert(String title, Long pid, Integer tagLevel);
	
	//获取所有标签，树形结构
	DubboResult<List<TagLibraryDto>> getAll();

	/**
	 * 获取用户画像相关标签
	 * @return
	 */
	DubboResult<List<TagLibraryDto>> getMediaUserPortraitTags();

	// 获取所有没有使用的流量分级标签updateMediaTag
	List<TagLibraryDto> getDomainGradeBlock();
	
	//标题模糊查询
	DubboResult<Set<String>> getLikeTitle(String title);
	
	//标题模糊查询获取id
	DubboResult<Set<Long>> getLikeId(String title);
	
	//删除一级标签
	DubboResult<Boolean> deleteTag1(Long id);
	
	//删除二级标签
	DubboResult<Boolean> deleteTag2(Long id);

	Integer deleteByAppIdAndBlockType(Long appId, Integer tagBlock);
	
	//标签的管理收敛于此类，即使是媒体的属性
	//媒体行业标签修改
	DubboResult<Boolean> updateMediaTag(MediaTagDto dto);

	/**
	 * 更新媒体风控标签
	 * @param dto 重新勾选的标签
	 * @return
	 */
	void updateRiskMediaTag(ReqUpdateRiskMediaTagDto dto);

	/**
	 * 更新用户画像标签
	 * @param dto 重新勾选的标签
	 * @return
	 */
	DubboResult<Boolean> updateMediaUserPortraitTag(ReqUpdateMediaUserPortraitTagDto dto);
	
	//通过标签获取关联appid
	DubboResult<List<Long>> getAppIdsByTag(Long tagId);
	
	//获取媒体标签
	@FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "30000")
	DubboResult<List<MediaTagDto>> getByAppIds(List<Long> appIds);

	//
	DubboResult<List<MediaTagDto>> getByIdsAndBlock(List<Long> ids, Integer tagBlock);

	List<MediaTagDto> getByTagIdAndBlock(Long taId, Integer tagBlock);

	/**
	 * 获取活动标签
	 *
	 * @param activityId 活动
	 * @return 活动标签
	 */
	List<Long> getTagsByActivityId(Long activityId);


	/**
	 * 根据标签获取活动id
	 *
	 * @param tagId 活动
	 * @return 活动标签
	 */
	List<Long> getActivityByTagId(Long tagId);

	/**
	 * 更新活动标签
	 *
	 * @param activityId 活动
	 * @param tagIds     标签
	 * @return 成功
	 */
	Boolean updateActivityTag(Long activityId, List<Long> tagIds);

	/**
	 * 活动标签树
	 *
	 * @return 活动标签树
	 */
	List<TagLibraryDto> getActivityTagLibrary();

	Boolean updateTag(TagLibraryDto tagLibraryDto);

	MediaTagDto queryMediaTagByAppIdType(Long appId, Integer blockType);

	String setHotActivityAndUploadTime(String activityInfoDataListStr);

	/**
	 * 获取素材标签树
	 * @return 素材标签树
	 */
	List<TagLibraryDto> getMaterialTagLibrary();

	/**
	 * 标签顺序初始化
	 * @return
	 */
	boolean tagSortInitialize();

	/**
	 * 批量更新标签顺序
	 * @param toUpdateList
	 * @return
	 */
	boolean batchUpdateTagSort(List<TagLibraryDto> toUpdateList);
}
