/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.ssp.center.api.constant;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum AgentSettlementTypeEnum {
    HZ_AGENT((byte)0, "\u93c9\ue15f\u5e39\u6d60\uff47\u608a\u7f01\u64b6\u757b\u9357\ufffd"),
    HEGS_AGENT((byte)1, "\u95c7\u5d86\u5e39\u6d60\uff47\u608a\u7f01\u64b6\u757b\u9357\ufffd"),
    HCDJ_AGENT((byte)2, "\u934f\u621e\u5d4e\u6d60\uff47\u608a\u7f01\u64b6\u757b\u9357\ufffd"),
    HZ_TO_HEGS_AGENT((byte)3, "\u93c9\ue15f\u5e39\u7efe\u51b2\u53c6\u95c7\u5d86\u5e39\u6d60\uff47\u608a\u7f01\u64b6\u757b\u9357\ufffd"),
    HZ_HEGS_TO_HCDJ_AGENT((byte)4, "\u93c9\ue15f\u5e39\u935c\u5c84\u6e47\u93ba\u3127\u64bc\u934f\u30e5\u53ac\u93b9\u8702\u552c\u941e\u55d9\u7ca8\u7ee0\u6940\u5d1f"),
    HZ_HCDJ_TO_HEGS_AGENT((byte)5, "\u93c9\ue15f\u5e39\u935c\u5c7d\u53ac\u93b9\u98ce\u64bc\u934f\u30e9\u6e47\u93ba\u3124\u552c\u941e\u55d9\u7ca8\u7ee0\u6940\u5d1f"),
    HZ_TO_HCDJ_AGENT((byte)6, "\u93c9\ue15f\u5e39\u7efe\u51b2\u53c6\u934f\u621e\u5d4e\u6d60\uff47\u608a\u7f01\u64b6\u757b\u9357\ufffd"),
    HEGS_TO_HZ_AGENT((byte)7, "\u95c7\u5d86\u5e39\u7efe\u51b2\u53c6\u93c9\ue15f\u5e39\u6d60\uff47\u608a\u7f01\u64b6\u757b\u9357\ufffd"),
    HCDJ_TO_HZ_AGENT((byte)8, "\u934f\u621e\u5d4e\u7efe\u51b2\u53c6\u93c9\ue15f\u5e39\u6d60\uff47\u608a\u7f01\u64b6\u757b\u9357\ufffd");

    private Byte type;
    private String desc;
    public static final Map<Byte, String> AGENT_COMPANY_MAP;
    public static final Map<Byte, AgentSettlementTypeEnum> AGENT_COMPANYENUM_MAP;
    public static final List<Byte> hegsList;
    public static final List<Byte> hcdjList;

    private AgentSettlementTypeEnum(Byte type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Byte getType() {
        return this.type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static String getCompanyName(Integer type) {
        for (AgentSettlementTypeEnum settlementType : AgentSettlementTypeEnum.values()) {
            if (!settlementType.getType().equals(type)) continue;
            return settlementType.getDesc();
        }
        return null;
    }

    public static Byte getSettlementType(Byte type) {
        if (hegsList.contains(type)) {
            return AgentSettlementTypeEnum.HEGS_AGENT.type;
        }
        if (hcdjList.contains(type)) {
            return AgentSettlementTypeEnum.HCDJ_AGENT.type;
        }
        return AgentSettlementTypeEnum.HZ_AGENT.type;
    }

    static {
        hegsList = Lists.newArrayList((Object[])new Byte[]{AgentSettlementTypeEnum.HEGS_AGENT.type, AgentSettlementTypeEnum.HZ_TO_HEGS_AGENT.type, AgentSettlementTypeEnum.HZ_HCDJ_TO_HEGS_AGENT.type});
        hcdjList = Lists.newArrayList((Object[])new Byte[]{AgentSettlementTypeEnum.HCDJ_AGENT.type, AgentSettlementTypeEnum.HZ_HEGS_TO_HCDJ_AGENT.type, AgentSettlementTypeEnum.HZ_TO_HCDJ_AGENT.type});
        HashMap<Byte, Object> temp = new HashMap<Byte, Object>(AgentSettlementTypeEnum.values().length, 1.0f);
        for (AgentSettlementTypeEnum tag : AgentSettlementTypeEnum.values()) {
            temp.put(tag.getType(), tag.getDesc());
        }
        AGENT_COMPANY_MAP = Collections.unmodifiableMap(temp);
        temp = new HashMap(AgentSettlementTypeEnum.values().length, 1.0f);
        for (AgentSettlementTypeEnum tag : AgentSettlementTypeEnum.values()) {
            temp.put(tag.getType(), (Object)tag);
        }
        AGENT_COMPANYENUM_MAP = Collections.unmodifiableMap(temp);
    }
}

