/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.ssp.center.api.econtract.util;

import cn.com.duiba.tuia.ssp.center.api.econtract.dto.bestsign.BestsignRequestResult;
import cn.com.duiba.tuia.ssp.center.api.econtract.dto.bestsign.BestsignRequestStringResult;
import cn.com.duiba.tuia.ssp.center.api.econtract.exception.BestsignResultErrorException;
import cn.com.duiba.tuia.ssp.center.api.econtract.util.BestsignPropertie;
import cn.com.duiba.tuia.ssp.center.api.econtract.util.RSAUtils;
import cn.com.duiba.tuia.ssp.center.api.econtract.util.RestRequestUtil;
import com.alibaba.fastjson.JSONObject;
import java.io.OutputStream;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class BestsignOpenApiClient {
    protected static Logger logger = LoggerFactory.getLogger(BestsignOpenApiClient.class);
    private static String baseUrlParams = "developerId=%s&rtick=%s&signType=rsa";

    public static <T> T getRequest(BestsignPropertie bestsignPropertie, String path, Map<String, String> params, Class<T> responseType) {
        String rtick = RSAUtils.getRtick();
        String urlParams = BestsignOpenApiClient.createUrlParams(bestsignPropertie, params, rtick);
        String paramsSign = RSAUtils.calcRsaSignNoEncode(bestsignPropertie.getDeveloperId(), bestsignPropertie.getPrivateKey(), bestsignPropertie.getServerHost(), path, rtick, urlParams, null);
        String requestUrl = urlParams + "&sign=" + paramsSign;
        return RestRequestUtil.sendHttpGet(bestsignPropertie.getServerHost(), path, requestUrl, responseType);
    }

    public static <T> BestsignRequestResult<T> postBestRequest(BestsignPropertie bestsignPropertie, String path, String sendData, Class<T> responseType) throws BestsignResultErrorException {
        BestsignRequestResult<T> result = BestsignOpenApiClient.buildResult(BestsignOpenApiClient.postRequest(bestsignPropertie, path, sendData), responseType);
        BestsignOpenApiClient.checkResult(result);
        return result;
    }

    public static String postRequest(BestsignPropertie bestsignPropertie, String path, String sendData) {
        String result = BestsignOpenApiClient.postRequest(bestsignPropertie, path, sendData, String.class);
        logger.info(String.format("\u9359\u6226\ufffd\u4f77\u7b02\u6d93\u5a44\ue137\u7487\u950b\u7730[%s],\u7487\u950b\u7730\u9359\u509b\u669f%s,\u935d\u5d85\u7c32\u7f01\u64b4\u7049%s", path, sendData, result));
        return result;
    }

    public static <T> T postRequest(BestsignPropertie bestsignPropertie, String path, String sendData, Class<T> responseType) {
        String rtick = RSAUtils.getRtick();
        String urlParams = BestsignOpenApiClient.createUrlParams(bestsignPropertie, null, rtick);
        String paramsSign = RSAUtils.calcRsaSignNoEncode(bestsignPropertie.getDeveloperId(), bestsignPropertie.getPrivateKey(), bestsignPropertie.getServerHost(), path, rtick, null, sendData);
        String requestUrl = urlParams + "&sign=" + paramsSign;
        return RestRequestUtil.sendHttpPost(bestsignPropertie.getServerHost(), path, requestUrl, sendData, responseType);
    }

    private static <T> BestsignRequestResult<T> buildResult(String resultBody, Class<T> dataType) {
        BestsignRequestStringResult bestsignRequestStringResult;
        if (StringUtils.isNotBlank((CharSequence)resultBody) && (bestsignRequestStringResult = (BestsignRequestStringResult)JSONObject.parseObject((String)resultBody, BestsignRequestStringResult.class)) != null) {
            return bestsignRequestStringResult.convert(dataType);
        }
        return null;
    }

    private static String createUrlParams(BestsignPropertie bestsignPropertie, Map<String, String> params, String rtick) {
        String baseUrl = String.format(baseUrlParams, bestsignPropertie.getDeveloperId(), rtick);
        StringBuilder urlParamsBuilder = new StringBuilder("?");
        urlParamsBuilder.append(baseUrl);
        if (!CollectionUtils.isEmpty(params)) {
            params.forEach((key, value) -> urlParamsBuilder.append("&").append((String)key).append("=").append((String)value));
        }
        return urlParamsBuilder.toString();
    }

    private static String createSignParams(Map<String, String> params) {
        if (!CollectionUtils.isEmpty(params)) {
            return params.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("&"));
        }
        return "";
    }

    public static void checkResult(BestsignRequestResult bestsignRequestResult) throws BestsignResultErrorException {
        if (bestsignRequestResult == null) {
            throw new BestsignResultErrorException("\u6d93\u5a41\u7b02\u7edb\u5267\u7ca8\u93cb\u6ec3\u6437\u6434\u65bf\u7d13\u752f\ufffd");
        }
    }

    public static void downloadByGet(BestsignPropertie bestsignPropertie, String path, Map<String, String> params, OutputStream outputStream) {
        String rtick = RSAUtils.getRtick();
        String signParams = BestsignOpenApiClient.createSignParams(params);
        String paramsSign = RSAUtils.calcRsaSignNoEncode(bestsignPropertie.getDeveloperId(), bestsignPropertie.getPrivateKey(), bestsignPropertie.getServerHost(), path, rtick, signParams, null);
        String urlParams = BestsignOpenApiClient.createUrlParams(bestsignPropertie, params, rtick);
        String requestUrl = urlParams + "&sign=" + paramsSign;
        RestRequestUtil.downloadByGet(bestsignPropertie.getServerHost(), path, requestUrl, outputStream);
    }
}

