/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.ssp.center.api.econtract.util;

import java.util.Objects;

public class EcontractConstant {
    private EcontractConstant() {
    }

    public static enum AutonomyStatus {
        AUTONOMY_STATUS_UNCERTIFIED(0, "\u93c8\ue047\ue17b\u7487\ufffd"),
        AUTONOMY_STATUS_FINANCE(1, "\u7490\u3220\u59df\u74a7\u52ee\u5ddd\u7481\u3088\u7609\u95ab\u6c33\u7e43"),
        AUTONOMY_STATUS_PROCURATOR(2, "\u93ba\u581f\u6f48\u6d60\uff47\u608a\u6d5c\u9e3f\ue17b\u7487\u4f80\ufffd\u6c33\u7e43"),
        AUTONOMY_STATUS_PAYAUTH(3, "\u93b5\u64b4\ue0d9\u7481\u3088\u7609\u95ab\u6c33\u7e43"),
        AUTONOMY_STATUS_SIGN(4, "\u935a\u581d\u6093\u7edb\u5267\u8bb2");

        private int status;
        private String desc;

        private AutonomyStatus(int status, String desc) {
            this.status = status;
            this.desc = desc;
        }

        public int getStatus() {
            return this.status;
        }

        public String getDesc() {
            return this.desc;
        }

        public boolean sameStatus(Integer status) {
            return Objects.equals(status, this.status);
        }

        public static String getStatusStr(Integer status) {
            if (status == null) {
                return "";
            }
            for (AutonomyStatus autonomyStatus : AutonomyStatus.values()) {
                if (!autonomyStatus.sameStatus(status)) continue;
                return autonomyStatus.desc;
            }
            return "";
        }
    }

    public static enum ContractStatus {
        CONTRACT_STATUS_UNCREATE(0, "\u93c8\ue046\u6553\u93b4\ufffd"),
        CONTRACT_STATUS_UNSIGN(1, "\u5bf0\u546f\ue137\u7f03\ufffd"),
        CONTRACT_STATUS_SIGNED(2, "\u7edb\u5267\u8bb2\u7039\u5c7e\u579a");

        private int status;
        private String desc;

        private ContractStatus(int status, String desc) {
            this.status = status;
            this.desc = desc;
        }

        public int getStatus() {
            return this.status;
        }

        public String getDesc() {
            return this.desc;
        }

        public boolean sameStatus(Integer contractStatus) {
            return Objects.equals(contractStatus, this.status);
        }
    }

    public static enum ContractType {
        CONTRACT_TYPE_HZ(0, "\u93c9\ue15e\u7a9e\u6d93\u8bb3\u7d8b\u935a\u581d\u6093"),
        CONTRACT_TYPE_HEGS(1, "\u95c7\u5d85\u76b5\u93cb\u6ec4\u67c9\u6d93\u8bb3\u7d8b\u935a\u581d\u6093");

        private int type;
        private String desc;

        private ContractType(int type, String desc) {
            this.type = type;
            this.desc = desc;
        }

        public int getType() {
            return this.type;
        }

        public String getDesc() {
            return this.desc;
        }

        public boolean sameType(Integer contractType) {
            return Objects.equals(this.type, contractType);
        }
    }

    public static enum PayAuthResult {
        PAY_AUTH_RESULT_UNCERTIFIED(0, "\u93c8\ue047\ue17b\u7487\ufffd"),
        PAY_AUTH_RESULT_SUCC(1, "\u6960\u5c83\u7609\u95ab\u6c33\u7e43"),
        PAY_AUTH_RESULT_FAIL(2, "\u6960\u5c83\u7609\u6fb6\u8fab\u89e6");

        private int result;
        private String desc;

        private PayAuthResult(int result, String desc) {
            this.result = result;
            this.desc = desc;
        }

        public int getResult() {
            return this.result;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum ProcuratorCheckType {
        CHECK_TYPE_THREE_ELEMENT(0, "\u6d93\ue043\u6c49\u6d93\u590e\ue6e6\u7ef1\u72b2\u7584\u935a\u5d88\ue17b\u7487\ufffd"),
        CHECK_TYPE_TOW_ELEMENT(1, "\u6d93\ue043\u6c49\u6d5c\u5c83\ue6e6\u7ef1\u72b2\u59de\u6d5c\u54c4\u4f10\u7039\u2103\u7273\u7481\u3088\u7609");

        private int type;
        private String desc;

        private ProcuratorCheckType(int type, String desc) {
            this.type = type;
            this.desc = desc;
        }

        public int getType() {
            return this.type;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum RealnameStatus {
        REALNAME_STATUS_UNCERTIFIED(0, "\u93c8\ue047\ue17b\u7487\ufffd"),
        REALNAME_STATUS_TOUPIMG(1, "\u5bf0\u546c\u7b02\u6d7c\u72b3\u589c\u93b8\u4f7d\u97e9\u6d60\u501f\u7609\u9413\ufffd"),
        REALNAME_STATUS_TOAUDIT(2, "\u7481\u3088\u7609\u6d93\ufffd:\u6d5c\u54c4\u4f10\u7039\u2103\u7273\u6d93\ufffd"),
        REALNAME_STATUS_TOPAY(3, "\u93b5\u64b4\ue0d9\u7481\u3088\u7609\u6d93\ufffd"),
        REALNAME_STATUS_SUCC(4, "\u7481\u3088\u7609\u93b4\u612c\u59db"),
        REALNAME_STATUS_FAIL(5, "\u7481\u3088\u7609\u6fb6\u8fab\u89e6");

        private int status;
        private String desc;

        private RealnameStatus(int status, String desc) {
            this.status = status;
            this.desc = desc;
        }

        public int getStatus() {
            return this.status;
        }

        public String getDesc() {
            return this.desc;
        }

        public boolean sameStatus(Integer realnameStatus) {
            return Objects.equals(this.status, realnameStatus);
        }
    }

    public static enum RealnameSubmitResult {
        SUBMIT_RESULT_SUCC(0, "\u74a7\u52ec\u67a1\u93cd\uffe0\u7359\u95ab\u6c33\u7e43\u6769\u6d98\u53c6\u6d93\u5b29\u7af4\u59dd\u30e4\u6c49\u5bb8\u30e5\ue178\u93cd\ufffd"),
        SUBMIT_RESULT_VCODE(1, "\u74a7\u52ec\u67a1\u93cd\uffe0\u7359\u95ab\u6c33\u7e43\u7edb\u590a\u7ddf\u6748\u64b3\u53c6\u6960\u5c83\u7609\u942e\ufffd"),
        SUBMIT_RESULT_IMG(2, "\u6d60\uff47\u608a\u6d5c\u8f70\u7b01\u7455\u4f7a\u790c\u7481\u3088\u7609\u6d93\u5d89\ufffd\u6c33\u7e43\u741b\u30e5\u5396\u97ec\ue0a1\u5524\u7487\u4f7a\u53ce\u9417\ufffd"),
        SUBMIT_RESULT_FAIL(3, "\u74a7\u52ec\u67a1\u93cd\uffe0\u7359\u6d93\u5d89\ufffd\u6c33\u7e43\u95c7\ufffd\u7455\u4f80\u5678\u6fc9\ufffd");

        private int result;
        private String desc;

        private RealnameSubmitResult(int result, String desc) {
            this.desc = desc;
            this.result = result;
        }

        public String getDesc() {
            return this.desc;
        }

        public int getResult() {
            return this.result;
        }

        public boolean sameResult(Integer result) {
            return Objects.equals(this.result, result);
        }

        public static boolean sameResult(RealnameSubmitResult realnameSubmitResult, Integer result) {
            return realnameSubmitResult != null && realnameSubmitResult.sameResult(result);
        }
    }

    public static enum AuditRefuseType {
        SUCC(0, "\u7039\u2103\u7273\u95ab\u6c33\u7e43"),
        PROCURAtOR_ERROR(1, "\u93b5\u5b2b\u5bd4\u97ec\ue0a1\u5524\u7487\u4f7a\u53ce\u9417\u56e6\u7b0c\u6fc9\ue0a2\u5553\u6dc7\u2103\u4f05\u6d93\u5d84\u7af4\u9477\ufffd"),
        POWER_ATTONEY_ERROR(2, "\u93ba\u581f\u6f48\u7487\u4f79\u69d1\u6dc7\u2103\u4f05\u93c8\u590e\ue1e4");

        private String desc;
        private int type;

        private AuditRefuseType(int type, String desc) {
            this.desc = desc;
            this.type = type;
        }

        public String getDesc() {
            return this.desc;
        }

        public int getType() {
            return this.type;
        }

        public boolean sameType(Integer refuseType) {
            return Objects.equals(this.type, refuseType);
        }

        public static String getRefuseMsg(Integer refuseType) {
            for (AuditRefuseType auditRefuseType : AuditRefuseType.values()) {
                if (!auditRefuseType.sameType(refuseType)) continue;
                return auditRefuseType.desc;
            }
            return "";
        }
    }

    public static enum AuditResult {
        AUDIT_RESULT_SUCC(1, "\u7039\u2103\u7273\u95ab\u6c33\u7e43"),
        AUDIT_RESULT_FAIL(2, "\u7039\u2103\u7273\u93b7\u6394\u7cb7");

        private String desc;
        private int result;

        private AuditResult(int result, String desc) {
            this.desc = desc;
            this.result = result;
        }

        public String getDesc() {
            return this.desc;
        }

        public int getResult() {
            return this.result;
        }

        public static boolean auditSucc(Integer result) {
            return AuditResult.sameResult(AUDIT_RESULT_SUCC, result);
        }

        public static boolean sameResult(AuditResult auditResult, Integer result) {
            return auditResult != null && auditResult.sameResult(result);
        }

        public boolean sameResult(Integer result) {
            return Objects.equals(this.result, result);
        }
    }
}

