/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.ssp.center.api.tool;

import cn.com.duiba.tuia.ssp.center.api.constant.SSPErrorCode;
import cn.com.duiba.tuia.ssp.center.api.dto.Result;
import cn.com.duiba.tuia.ssp.center.api.tool.ExecuteCallBack;
import cn.com.duiba.tuia.ssp.center.api.tool.StackTraceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteExcuteTemplateHandle {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteExcuteTemplateHandle.class);

    public static <T> Result<T> execute(ExecuteCallBack<T> callBack, Logger logger, String reqJsonString) {
        try {
            return callBack.process();
        }
        catch (Exception e) {
            return RemoteExcuteTemplateHandle.handleException(e, logger, reqJsonString);
        }
    }

    private static <T> Result<T> handleException(Exception e, Logger logger, String reqJsonString) {
        try {
            String message = e.getMessage();
            message = message.substring(message.indexOf("message") + 10, message.indexOf("timestamp") - 3);
            String methodName = StackTraceUtil.getCallMethodName(2);
            logger.error(methodName + " \u93c8\u5d85\u59df\u748b\u51aa\u6564\u5bee\u509a\u7236\u951b\u5c83\ue1ec\u59f9\u509a\u5f2c\u93c1\ufffd:{}, errorMsg:{}", new Object[]{reqJsonString, message, e});
            return Result.error(SSPErrorCode.SSP_111111.getCode(), message);
        }
        catch (Throwable throwable) {
            LOGGER.error("handleException throwable", (Throwable)e);
            return Result.error(SSPErrorCode.SSP_111111);
        }
    }
}

