package cn.com.duiba.tuia.ssp.center.api.dto;

import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * 媒体链接审核表
 *
 * @author YWG.MID.P
 * @email tangzhen@tuia.com.cn
 * @date 2020-06-03 10:57:32
 */
@Data
public class MediaLinkCheckDTO implements Serializable {

    private Long id;
    /**
     * 应用ID
     */
    private Long appId;
    /**
     * 广告计划ID
     */
    private Long advertPlanId;
    /**
     * 广告计划名称
     */
    private String advertPlanName;
    /**
     * 广告计划类型 1定向/2通投
     */
    private Integer advertPlanType;
    /**
     * AE名称
     */
    private String aeName;
    /**
     * 资源标签
     */
    private String resourceTag;
    /**
     * 审核状态:0-待审核,1-已通过,2-已拒绝
     */
    private Integer checkStatus;

    private String checkStatusMsg;
    /**
     * 域名
     */
    private String pageHost;
    /**
     * 落地页URL
     */
    private String pageUrl;
    /**
     * 素材URL
     */
    private String sckUrl;
    /**
     * 操作人
     */
    private String gmtUserName;

    /**
     * 创建时间
     */
    private Date gmtCreate;
    /**
     * 修改时间
     */
    private Date gmtModified;

    /** 当前页*/
    private Integer currentPage = 1;

    /** 每页记录数*/
    private Integer pageSize = 20;

    private Date startTime;
    private Date endTime;

    private List<Long> ids;
    private List<Long> appIds;
    private List<String> pageHosts;
    private List<String> pageUrls;


    public boolean chechParams(){
        if (Objects.isNull(appId) || Objects.isNull(advertPlanId)|| Objects.isNull(pageUrl)) {
            return false;
        }
        return true;
    }


}
