package cn.com.duiba.tuia.ssp.center.api.tool;

import java.util.*;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

/**
 * The Class StringTool.
 */
public class StringTool {

    private StringTool(){}

    /**
     * list转成String.<br>
     * 分隔符为","
     * 
     * @param list the list
     * @return the string by list
     */
    public static String getStringByList(List<String> list) {
        return getStrByCollection(list);
    }

    /**
     * string 转成List<String>.<br>
     * 分隔符为","
     * 
     * @param arrayStr the array str
     * @return the string list by str
     */
    public static List<String> getStringListByStr(String arrayStr) {

        if (StringUtils.isNotEmpty(arrayStr)) {
            List<String> list = new ArrayList<>();
            String[] array = arrayStr.split(",");
            for (String s : array) {
                list.add(s);
            }
            return list;
        } else {
            return Collections.emptyList();
        }
    }

    /**
     * collection转成String.<br>
     * 分隔符为","
     *
     * @param collection the collection
     * @return the string by collection
     */
    public static String getStrByCollection(Collection<String> collection) {
        if (!CollectionUtils.isEmpty(collection)) {
            StringBuilder builder = new StringBuilder();
            for (String str : collection) {
                builder.append(str);
                builder.append(",");
            }

            return builder.substring(0, builder.length() - 1);
        }
        return StringUtils.EMPTY;
    }

    /**
     * string 转成Set<String>.<br>
     * 分隔符为","
     *
     * @param arrayStr the array str
     * @return the string Set by str
     */
    public static Set<String> getStrSetByStr(String arrayStr) {

        if (StringUtils.isNotEmpty(arrayStr)) {
            Set<String> set = new HashSet<>();
            String[] array = arrayStr.split(",");
            for (String s : array) {
                set.add(s);
            }
            return set;
        } else {
            return Collections.emptySet();
        }
    }


    /**
     * 把一个2,44,51,34,123,123,4（都是数字）形式的字符串解析成一个List<Long>.
     *
     * @param arrayStr the array str
     * @return the long list by str
     */
    public static List<Long> getLongListByStr(String arrayStr) {
        if (StringUtils.isBlank(arrayStr)) {
            return Collections.emptyList();
        }
        String[] array = arrayStr.split(",");
        List<Long> list = new ArrayList<>();
        for (String s : array) {
            list.add(Long.valueOf(s));
        }
        return list;
    }

    /**
     * 把一个2,44,51,34,123,123,4（都是数字）形式的字符串解析成一个List<Long>，此处symbol为",".
     *
     * @param arrayStr the array str
     * @param symbol 字符串分隔符
     * @return the long list by str
     */
    public static List<Long> getLongListByStr(String arrayStr, String symbol) {
        if (StringUtils.isBlank(arrayStr)) {
            return Collections.emptyList();
        }
        String[] array = arrayStr.split(symbol);
        List<Long> list = new ArrayList<>();
        for (String s : array) {
            if (StringUtils.isEmpty(s) || " ".equals(s)) {
                continue;
            }
            list.add(Long.valueOf(s));
        }
        return list;
    }

    /**
     * Join all values separating them with a comma.
     */
    public static String join(String... values) {
        if (values == null || values.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String value : values) {
            sb.append(',').append(value);
        }
        return sb.substring(1);
    }

}
