package cn.com.duiba.tuia.ssp.center.api.dto.externalplatformmedia;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class ExternalPlatformMediaAccountDTO implements Serializable {

    private static final long serialVersionUID = -8473128946405682672L;

    /**
     * 账号id
     */
    private Long id;

    /**
     * 媒体标识符
     */
    private Integer mediaType;

    /**
     * 媒体名称
     */
    private String mediaName;

    /**
     * 账号名称
     */
    private String accountName;

    /**
     * 余额
     */
    private String balanceStr;

    /**
     * 余额
     */
    private BigDecimal balance;


    /**
     * 媒体消耗
     */
    private String mediaConsumeStr;

    /**
     * 媒体消耗
     */
    private BigDecimal mediaConsume;

    /**
     * 媒体返点
     */
    private Double mediaRebate;

    /**
     * 入口素材曝光数
     */
    private Long entryMaterialExposureCount;

    /**
     * 入口素材点击数
     */
    private Long entryMaterialClickCount;

    /**
     * 入口素材点击率
     */
    private Double entryMaterialClickRate;

    /**
     * 登录名
     */
    private String loginName;

    /**
     * 登陆密码
     */
    private String loginPassword;

    /**
     * 运营人员
     */
    private String operatorName;

    /**
     * 运营人员id
     */
    private Long operatorId;

    /**
     * 广告位id
     */
    private String slotId;

    /**
     * 账户状态:0.冻结 1.正常
     */
    private Integer status;

    /**
     * 是否删除:0.未删除 1.已删除
     */
    private Integer deleteFlag;


    private String createTime;


    private String updateTime;

    public ExternalPlatformMediaAccountDTO(Long id) {
        this.id = id;
    }

}
