package cn.com.duiba.tuia.ssp.center.api.remote.industryPenetration.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.util.Objects;

/**
 * 已对接应用
 * @dateTime 2020-05-13 11:51:27
 * @author haitao.hua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = false, chain = true, prefix = "")
public class MediaApplication implements Serializable {

    /**
     * 自增主键
     */
    private Long id;

    /**
     * 媒体 Id ( 媒体应用 )
     */
    private String mediaId;

    /**
     * 媒体名称 ( 媒体应用 )
     */
    private String mediaName;

    /**
     * 应用 Id
     */
    private String appId;

    /**
     * 应用名称
     */
    private String appName;

    /**
     * 类别 Id
     */
    private String sortId;

    /**
     * 类别名称
     */
    private String sortName;

    /**
     * 媒介 Id
     */
    private String mediumId;

    /**
     * 媒介名称
     */
    private String mediumName;

    /**
     * 媒体应用 · 创建时间
     */
    private String creationTime;

    /**
     * 接入状态 · 识别码
     * -- 可选值 : { "00": "未接入", "10": "已接入 · 无消耗", "11": "已接入 · 有消耗" }.
     */
    private String status;


    public MediaApplication(String appId, String appName, String sortId, String sortName, String status) {
        this.appId = appId;
        this.appName = appName;
        this.sortId = sortId;
        this.sortName = sortName;
        this.status = status;
    }

    /**
     * Check 参数
     * 注: Check 是否缺失 · { true :: 缺失 , false :: 不缺失 }
     */
    public boolean check() {
        return Objects.isNull(id) ? additionCheck() : modifyCheck();
    }

    /**
     * Check 参数 · 新增
     */
    private boolean additionCheck() {
        return (Objects.isNull(mediaId) || Objects.isNull(mediaName) || Objects.isNull(appId) || Objects.isNull(appName) || Objects.isNull(sortId) || Objects.isNull(sortName) || Objects.isNull(mediumId) || Objects.isNull(mediumName) || Objects.isNull(creationTime) || Objects.isNull(status));
    }

    /**
     * Check 参数 · 更新
     */
    private boolean modifyCheck() {
        return (Objects.isNull(appId) || Objects.isNull(appName) || Objects.isNull(sortId) || Objects.isNull(sortName) || Objects.isNull(status));
    }

}