/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.ssp.center.api.tool;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetEndOfDay {
    private static Logger logger = LoggerFactory.getLogger(GetEndOfDay.class);
    public static final SimpleDateFormat YEAR_MONTH = GetEndOfDay.getFormat("yyyy-MM");

    private GetEndOfDay() {
    }

    private static SimpleDateFormat getFormat(String format) {
        return new SimpleDateFormat(format);
    }

    public static String getEndTime(String endDate) {
        return new DateTime((Object)endDate).millisOfDay().withMaximumValue().toString("yyyy-MM-dd HH:mm:ss");
    }

    public static Date getDate(String dateStr, SimpleDateFormat format) {
        if ("".equals(dateStr) || dateStr == null) {
            return null;
        }
        try {
            return format.parse(dateStr);
        }
        catch (ParseException e) {
            logger.error("format yyyy-MM-dd HH:mm:ss error:", (Throwable)e);
            return null;
        }
    }

    public static String getStr(Date date, SimpleDateFormat format) {
        if (date == null) {
            return "";
        }
        return format.format(date);
    }
}

