/**
 * Project Name:media-api File Name:MaterialStatisticsDto.java Package Name:cn.com.duiba.tuia.media.api.dto
 * Date:2017年3月15日上午9:55:43 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName:MaterialStatisticsDto <br/>
 * Function: 活动素材. <br/>
 * Date: 2017年3月15日 上午9:55:43 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public class MaterialStatisticsDto extends BaseDto {

    /** 序列号 */
    private static final long serialVersionUID = -6232248422791575048L;

    /** 广告位规格 */
    private Long              msId;
    /** 广告位ID */
    private Long              slotId;
    /** 活动ID */
    private Long              activityId;
    /** 活动类型 */
    private Integer           activityType;
    /** 活动素材ID */
    private Long              materialId;
    /** 应用ID */
    private Long              appId;
    /** 当前时间 */
    private Date              curDate;
    /** 曝光量 */
    private Long              exposureCount;
    /** 点击量 */
    private Long              clickCount;
    /**活动来源*/
    private Integer           activitySource;
    
    /**素材库id*/
    private Long           sckId;

    /** 点击量/曝光量 **/
    private Double         ctr;

    /**
     * adx消耗
     */
    private Long adxCost;

    /**
     * adx广告主消耗(含增值)
     */
    private Long adCost;

    /**
     * 分成比例，计算公式=adx_cost/（ad_cost/1.15）
     */
    private Double shareRatio;
    
    public Long getMsId() {
        return msId;
    }

    public void setMsId(Long msId) {
        this.msId = msId;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Date getCurDate() {
        return curDate;
    }

    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    public Long getExposureCount() {
        return exposureCount;
    }

    public void setExposureCount(Long exposureCount) {
        this.exposureCount = exposureCount;
    }

    public Long getClickCount() {
        return clickCount;
    }

    public void setClickCount(Long clickCount) {
        this.clickCount = clickCount;
    }

    public Integer getActivityType() {
        return activityType;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }
    
    public Integer getActivitySource() {
        return activitySource;
    }

    
    public void setActivitySource(Integer activitySource) {
        this.activitySource = activitySource;
    }

    
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

	public Long getSckId() {
		return sckId;
	}

	public void setSckId(Long sckId) {
		this.sckId = sckId;
	}

    public Double getCtr() {
        return ctr;
    }

    public void setCtr(Double ctr) {
        this.ctr = ctr;
    }

    public Long getAdxCost() {
        return adxCost;
    }

    public void setAdxCost(Long adxCost) {
        this.adxCost = adxCost;
    }

    public Long getAdCost() {
        return adCost;
    }

    public void setAdCost(Long adCost) {
        this.adCost = adCost;
    }

    public Double getShareRatio() {
        return shareRatio;
    }

    public void setShareRatio(Double shareRatio) {
        this.shareRatio = shareRatio;
    }
}
