package cn.com.duiba.tuia.ssp.center.api.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * 手投预估数据
 *
 * @author zhangzhenghe
 * @since 2020-04-10 3:55 PM
 */
@Data
public class RspManualSlotDailyData implements Serializable {

    private static final long serialVersionUID = 1081157467736417670L;

    private Long id;

    /**
     * 媒体ID
     */
    private Long appId;

    /**
     * 广告位ID
     */
    private Long slotId;

    /**
     * 广告位名称
     */
    private String slotName;

    /**
     * 当天日期
     */
    private Date curDate;

    /**
     * 广告位曝光PV
     */
    private Long actExposeCount;

    /**
     * 广告位点击PV
     */
    private Long actClickCount;

    /**
     * 广告位点击UV
     */
    private Long actClickUv;

    /**
     * 计费方式
     */
    private Integer chargeType;

    /**
     * 计费价格
     */
    private Long price;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}
