/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.ssp.center.api.query;

import java.io.Serializable;

public class Sort
implements Serializable {
    private static final long serialVersionUID = -3992572843995793776L;
    private String column;
    private SortType type;

    public Sort(String column, SortType type) {
        this.column = column;
        this.type = type;
    }

    public String getColumn() {
        return this.column;
    }

    public SortType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Sort)) {
            return false;
        }
        Sort sort = (Sort)o;
        if (this.column != null ? !this.column.equals(sort.column) : sort.column != null) {
            return false;
        }
        return this.type == sort.type;
    }

    public int hashCode() {
        int result = this.column != null ? this.column.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.column + ' ' + this.type.getMessage();
    }

    public static enum SortType {
        ASC(0, "ASC"),
        DESC(1, "DESC");

        private int value;
        private String message = null;

        private SortType(int value, String message) {
            this.value = value;
            this.message = message;
        }

        public int getValue() {
            return this.value;
        }

        public String getMessage() {
            return this.message;
        }

        public static SortType getByValue(int value) {
            for (SortType sortTypeEnum : SortType.values()) {
                if (sortTypeEnum.getValue() != value) continue;
                return sortTypeEnum;
            }
            return null;
        }

        public String toString() {
            return this.value + "|" + this.message;
        }
    }
}

