package cn.com.duiba.tuia.ssp.center.api.constant;

import java.util.Objects;

public enum ClientType {

    NOT_SELECTED("未选择",0),
    MANUAL_WORK("人工服务客户",1),

    AUTO_CLIENT("在线自助客户",2);

    private String desc;

    private Integer code;

    ClientType(String desc, Integer code) {
        this.desc = desc;
        this.code = code;
    }


    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }


    public static String getDescByCode(Integer code){
        if (code == null){
            return NOT_SELECTED.desc;
        }
      for (ClientType type:ClientType.values()){
            if (Objects.equals(code,type.getCode())){
                return type.getDesc();
            }
      }
      return "";
    }
}
