package cn.com.duiba.tuia.ssp.center.api.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

@EqualsAndHashCode(callSuper = true)
@Data
public class ReqExternalEstimateScore extends BaseQueryDto {

    private static final long serialVersionUID = 5142680367564774839L;

    /**
     * 媒体ID
     */
    private Long appId;

    /**
     * 打分规则（1:大盘默认 2:ADX媒体）
     */
    private Integer type;

    /**
     * 日期
     */
    private Date curDate;

    /**
     * 开始日期
     */
    private String startDate;

    /**
     * 结束日期
     */
    private String endDate;

    /**
     * 媒体ID列表
     */
    @JsonIgnore
    private List<Long> appIds;
}

