package cn.com.duiba.tuia.ssp.center.api.remote.industryPenetration;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.remote.industryPenetration.dto.*;
import java.util.List;

/**
 * { 行业 } 渗透趋势 RemoteService
 * @dateTime 2020-07-13 11:51:27
 * @author haitao.hua
 */
@AdvancedFeignClient
public interface RemotePenetrationTrendService {


    /**
     * { 行业 } 类别清单
     * @return 处理结果
     */
    CategoryListing category() throws BizException;

    /**
     * { 已接入 } 应用 Uv 统计
     * @param appId 应用 Id
     * @param yesterday 统计昨天 { true : 昨天, false : 当天 }
     * @return 处理结果
     */
    AlreadyApplicationExtend applicationUvStatistical(long appId, boolean yesterday) throws BizException;

    /**
     * { 已接入 } 应用清单
     * @return 处理结果
     */
    List<AlreadyApplication> alreadyApplication() throws BizException;

}
