package cn.com.duiba.tuia.ssp.center.api.dto;

import lombok.Data;

import java.io.Serializable;

@Data
public class ExternalScoreConfigDTO implements Serializable {

    private static final long serialVersionUID = -6383342055211029297L;

    /**
     * 媒体数量
     */
    private Integer appNum;

    /**
     * 配置类型（1:大盘默认 2:ADX媒体）
     */
    private Integer type;

    /**
     * 流量分（百分比，最大值100）
     */
    private Integer flowRatio;

    /**
     * 价值性（百分比，最大值100）
     */
    private Integer valueRatio;

    /**
     * 稳定性（百分比，最大值100）
     */
    private Integer stableRatio;

    /**
     * 质量分（百分比，最大值100）
     */
    private Integer qualityRatio;

    /**
     * 匹配度（百分比，最大值100）
     */
    private Integer matchingRatio;

    /**
     * 影响力（百分比，最大值100）
     */
    private Integer effectRatio;

    /**
     * 真实性（百分比，最大值100）
     */
    private Integer truthRatio;

    /**
     * 变现能力（百分比，最大值100）
     */
    private Integer cashoutRatio;

}
