/**
 * Project Name:media-api File Name:RspMediaAppDto.java Package Name:cn.com.duiba.tuia.media.api.dto
 * Date:2016年10月8日下午5:15:30 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import cn.com.duiba.tuia.ssp.center.api.annotation.SensitiveInfo;
import cn.com.duiba.tuia.ssp.center.api.annotation.SensitiveType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.List;

/**
 * ClassName:RspMediaAppDto <br/>
 * Function: 媒体配置信息dto. <br/>
 * Date: 2016年10月8日 下午5:15:30 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
@ApiModel
@SensitiveInfo(sensitiveFields = { "email" })
public class RspMediaAppConfigDto implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = 8345975270551669780L;

    /** 媒体Id */
    private Long              appId;
    /** 媒体名称 */
    private String            appName;
    /* 公司名称 */
    private String            companyName;
    /** 媒体平台 */
    private String            platform;
    /** 邮箱账号 */
    @SensitiveInfo(sensitiveType = SensitiveType.EMAIL)
    private String            email;
    /** 开通状态. */
    private Integer           checkStatus;
    /** 拒绝审核理由. */
    private String            refuseMsg;
    /** 创建日期 */
    private String            createDate;
    /** 用户ID */
    private Long              mediaId;
    /** 管理人员id 集合(权限) */
    private List<Long>        managerList;
    /** 管理人员名称 集合(权限) */
    private List<String>      managerNameList;
    /** 媒体冻结原因 */
    private String            mediaFrozenReason;
    /** 媒体冻结状态 */
    private Integer           mediaFrozenStatus;
    /** 一级标签名称 **/
    private String            tagName1;
    /** 二级标签名称 **/
    private String            tagName2;

    /** 账户类别 */
    private Integer           accountType;

    /** 媒体流量标签名称 **/
    private String            flowTagName;
    /** 流量分级标签名称 **/
    private String            gradeTagName;
    /** 网赚标签 */
    private String            emoTagName;

    /** 如果是子账号，媒体实际属于的账号ID */
    private Long              subMediaId;

    /** 是否是海外媒体 */
    private Integer           overseas;
    /** 审核时间 */
    private String           auditTime;

    private Integer          clientType;

    private String          clientTypeString;

    @ApiModelProperty(value = "标签校验提示，多条以逗号分割")
    private String tagCheckMsg;

    public String getAuditTime() {
        return auditTime;
    }

    public void setAuditTime(String auditTime) {
        this.auditTime = auditTime;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    public String getRefuseMsg() {
        return refuseMsg;
    }

    public void setRefuseMsg(String refuseMsg) {
        this.refuseMsg = refuseMsg;
    }

    public String getCreateDate() {
        return createDate;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public List<Long> getManagerList() {
        return managerList;
    }

    public void setManagerList(List<Long> managerList) {
        this.managerList = managerList;
    }

    public List<String> getManagerNameList() {
        return managerNameList;
    }

    public void setManagerNameList(List<String> managerNameList) {
        this.managerNameList = managerNameList;
    }

    public String getMediaFrozenReason() {
        return mediaFrozenReason;
    }

    public void setMediaFrozenReason(String mediaFrozenReason) {
        this.mediaFrozenReason = mediaFrozenReason;
    }

    public Integer getMediaFrozenStatus() {
        return mediaFrozenStatus;
    }

    public void setMediaFrozenStatus(Integer mediaFrozenStatus) {
        this.mediaFrozenStatus = mediaFrozenStatus;
    }

    public Integer getAccountType() {
        return accountType;
    }

    public void setAccountType(Integer accountType) {
        this.accountType = accountType;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public String getTagName1() {
        return tagName1;
    }

    public void setTagName1(String tagName1) {
        this.tagName1 = tagName1 == null ? "无" : tagName1;
    }

    public String getTagName2() {
        return tagName2;
    }

    public void setTagName2(String tagName2) {
        this.tagName2 = tagName2 == null ? "无" : tagName2;
    }

    public String getFlowTagName() {
        return flowTagName;
    }

    public void setFlowTagName(String flowTagName) {
        this.flowTagName = flowTagName == null ? "无" : flowTagName;
    }

    public String getGradeTagName() {
        return gradeTagName;
    }

    public void setGradeTagName(String gradeTagName) {
        this.gradeTagName = gradeTagName;
    }

    public String getEmoTagName() {
        return emoTagName;
    }

    public void setEmoTagName(String emoTagName) {
        this.emoTagName = emoTagName;
    }

    public Long getSubMediaId() {
        return subMediaId;
    }

    public void setSubMediaId(Long subMediaId) {
        this.subMediaId = subMediaId;
    }

    public Integer getOverseas() {
        return overseas;
    }

    public void setOverseas(Integer overseas) {
        this.overseas = overseas;
    }

    public Integer getClientType() {
        return clientType;
    }

    public void setClientType(final Integer clientType) {
        this.clientType = clientType;
    }

    public String getClientTypeString() {
        return clientTypeString;
    }

    public void setClientTypeString(final String clientTypeString) {
        this.clientTypeString = clientTypeString;
    }

    public String getTagCheckMsg() {
        return tagCheckMsg;
    }

    public void setTagCheckMsg(String tagCheckMsg) {
        this.tagCheckMsg = tagCheckMsg;
    }
}
