/**
 * Copyright (c) 2018, Ysoul. All rights reserved.
 */
package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.DomainWarningStrategyDto;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.params.DomainWarningStrategyQuery;

/**
 * 类描述: 域名管理查询
 *
 * @author <a href="651850874@qq.com">Ysoul</a>
 * @version 1.0 2018-01-24
 * @since 1.0
 */
@AdvancedFeignClient
public interface RemoteDomainWarningStrategyService {

    /**
     * 查询
     *
     * @param id
     * @return
     */
    DomainWarningStrategyDto selectById(Long id);

    /**
     * 分页查询
     *
     * @param query
     * @return
     */
    PageResultDto<DomainWarningStrategyDto> selectByParams(DomainWarningStrategyQuery query);

    /**
     * 插入
     *
     * @param domainWarningStrategyDto
     * @return
     */
    int insert(DomainWarningStrategyDto domainWarningStrategyDto);

    /**
     * 更新
     *
     * @param domainWarningStrategyDto
     * @return
     */
    int update(DomainWarningStrategyDto domainWarningStrategyDto);

}
