package cn.com.duiba.tuia.ssp.center.api.remote.media.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.util.Date;

/**
 * 可投放广告
 * @dateTime 2019-11-07 09:31:27
 * @author haitao.hua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = false, chain = true, prefix = "")
public class CanServeAdvertDto implements Serializable {

    public CanServeAdvertDto(Long advertId, Long materialId, Date gmtModified, Long appId) {
        this.advertId = advertId;
        this.materialId = materialId;
        this.gmtModified = gmtModified;
        this.appId = appId;
    }

    /*
     * 序列化 SerialVersionUId
     */
    private static final long serialVersionUID = 1L;

    /*
     * 广告 Id
     */
    private Long advertId;

    /*
     * 广告位id
     */
    private Long slotId;

    /*
     * 素材 Id
     */
    private Long materialId;

    /*
     * 更新时间
     */
    private Date gmtModified;

    /*
     * 媒体id
     */
    private Long appId;

    /**
     * 重写 ToString
     * @return 结果
     */
    @Override
    public String toString() {
        StringBuilder builder;
        builder = new StringBuilder(getClass().getSimpleName());
        builder.append(" [ ").append("Hash = ").append(hashCode())
                .append(", advertId=").append(advertId)
                .append(", materialId=").append(materialId)
                .append(", gmtModified=").append(gmtModified)
                .append(", serialVersionUID=").append(serialVersionUID).append(" ]");
        return builder.toString();
    }

}