package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;

public class MediaTagDto implements Serializable{
	private static final long serialVersionUID = -8016271393111831999L;
	
	public static final int INDUSTRY_BLOCK = 1;//媒体行业模块
	public static final int FLOW_BLOCK = 2;//媒体流量模块
	public static final int SLOT_BLOCK = 3;//广告位模块
	public static final int GRADE_BLOCK = 4;//媒体流量分级模块
	public static final int DOMAIN_GRADE_BLOCK = 5;//域名策略流量分级模块 共用媒体流量分级模块
    public static final int RISK_BLOCK = 6;//风控模块
    public static final int MEDIA_USER_PORTRAIT_BLOCK = 7;//用户画像模块
    public static final int EMO_BLOCK = 8;// earn money online缩写，网赚

	private Long appId;

    private Long pid;

    private Long tagId;

    private String title;

    //标签所属模块：1行业,2媒体流量,3广告位性质
    /**
     * {@link cn.com.duiba.tuia.ssp.center.api.constant.TagBlockEnum}
     * */
    private Integer tagBlock;

    /**
     * 多个标签则用,分割，大类ID组别ID标签ID之间用-分割，如“5-21-249,5-22-250”
     */
    private String tagIds;

    /**
     * 组别-标签名称
     */
    private String groupTagName;

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public Long getTagId() {
        return tagId;
    }

    public void setTagId(Long tagId) {
        this.tagId = tagId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title == null ? null : title.trim();
    }

	public Integer getTagBlock() {
		return tagBlock;
	}

	public void setTagBlock(Integer tagBlock) {
		this.tagBlock = tagBlock;
	}

	public boolean needSendMq() {
        return tagBlock != null && (tagBlock == 1 || tagBlock == 2 || tagBlock == 3);
    }

    public String getTagIds() {
        return tagIds;
    }

    public void setTagIds(String tagIds) {
        this.tagIds = tagIds;
    }

    public String getGroupTagName() {
        return groupTagName;
    }

    public void setGroupTagName(String groupTagName) {
        this.groupTagName = groupTagName;
    }
}