package cn.com.duiba.tuia.ssp.center.api.remote.media;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.TagAdvertInfoDto;
import cn.com.duiba.tuia.ssp.center.api.dto.media.MediaAdvertDto;
import cn.com.duiba.tuia.ssp.center.api.remote.media.dto.CanServeAdvertDto;
import cn.com.duiba.tuia.ssp.center.api.remote.media.dto.TestingMaterialDto;
import cn.com.duiba.tuia.ssp.center.api.remote.media.dto.TestingMaterialVo;
import cn.com.duiba.tuia.ssp.center.api.remote.media.dto.meituan.request.ListingRequest;
import cn.com.duiba.tuia.ssp.center.api.remote.media.dto.meituan.response.PagingResponse;
import cn.com.duiba.tuia.ssp.center.api.remote.media.dto.meituan.response.ResultResponse;
import cn.com.duiba.tuia.ssp.center.api.remote.media.enums.MaterialSwitchEnum;
import cn.com.duiba.tuia.ssp.center.api.remote.media.enums.ReviewTypeEnum;

import java.util.List;
import java.util.Map;

/**
 * 美团 RemoteService
 * @dateTime 2019-09-26 17:51:27
 * @author haitao.hua
 */
@AdvancedFeignClient
public interface RemoteMeituanService {


    /**
     * { 全局 } 同步送审
     * 注: 同步关联广告主及广告主对应关联广告集合.
     * @return 响应结果
     */
    ResultResponse sync();

    /**
     * { 全局 } 刷新状态
     * @return 响应结果
     */
    ResultResponse refreshAllStatus();

    /**
     * { 单个 } 刷新状态
     * @param creativeId 创意 Id
     * @return 响应结果
     */
    ResultResponse refreshStatus(Long creativeId);

    /**
     * { 获取 } 送审列表
     * @param request 请求入参
     * @return 响应结果
     */
    ResultResponse listingAdvert(ListingRequest request);


    /**
     * { 获取 } 送审列表
     * @param request 请求入参
     * @return 响应结果
     */
    List<MediaAdvertDto> getListingAdvertByReq(ListingRequest request);


    /**
     * 提交送审
     * @param advert 广告信息
     * @param typeEnum 类型枚举
     * @return 处理结果
     */
    boolean submitReview(TagAdvertInfoDto advert, ReviewTypeEnum typeEnum);

    /**
     * 素材开关
     * @param materialId 素材 Id
     * @param switchEnum 开关枚举
     * @return 处理结果
     */
    boolean materialSwitch(Long materialId, MaterialSwitchEnum switchEnum);

    /**
     * { 获取 } 可投放广告
     * @param slotId 广告位 Id
     * @return 处理结果
     */
    List<CanServeAdvertDto> canServeAdvert(Long slotId);

    /**
     * { 获取 } 可投放广告
     * @param advertId 广告 Id
     * @return 处理结果
     */
    List<CanServeAdvertDto> canServeAdvertByAdvertId(Long advertId);

    /**
     * { 获取 } 可见广告
     * @param mediaId 媒体 Id
     * @return 处理结果
     */
    Map<Long, TagAdvertInfoDto> visibleAdvert(Long mediaId);

    /**
     * { 获取 } 创意 Id
     * 注: 美团 Adx 竞价出创意使用.
     * @param advertId 广告 Id
     * @param materialId 素材 Id
     * @return 处理结果
     */
    String selectByCreativeId(Long advertId, Long materialId);

    /**
     * { 获取 } 创意 Id
     * 注: 美团 Adx 竞价出创意使用.
     * @param advertId 广告 Id
     * @param materialId 素材 Id
     * @param landingPage 落地页 Url
     * @return 处理结果
     */
    String selectCreativeId(Long advertId, Long materialId, String landingPage);

    /**
     * 获取美团所有可投放广告
     * @return
     */
    List<CanServeAdvertDto> selectCanServeAdverts();


    /**
     * 获取美团单条可投放广告
     * @return
     */
    CanServeAdvertDto selectOneCanServeAdvert();


    /**
     * 测试素材·送审
     * @param testingMaterial 测试素材
     * @return 处理结果
     */
    ResultResponse<Boolean> testingMaterialSubmitReview(TestingMaterialDto testingMaterial);

    /**
     * 测试素材·列表
     * @param advertId 广告 Id
     * @param auditType 送审类型 1:手动送审 2:自动送审
     * @param materialId 素材id
     * @param landPageUrl 落地页url
     * @param currentPage 分页页数·{ 默认 : 1 }
     * @param pageSize 分页条数·{ 默认 : 20 }
     * @return 处理结果
     */
    PagingResponse<TestingMaterialVo> testingMaterialListing(Long advertId, Integer auditType, Long materialId, String landPageUrl, Integer currentPage, Integer pageSize);

    /**
     * 分页获取美团所有可投放广告
     * @param currPage 页数
     * @param pageSize 数据量
     * @return
     */
    List<CanServeAdvertDto> selectCanServeAdvertsWithPage(int currPage, int pageSize);


}
