/**
 * Project Name:media-api<br>
 * File Name:RspSlotDetailDto.java<br>
 * Package Name:cn.com.duiba.tuia.media.api.dto.rsp<br>
 * Date:2016年10月14日上午9:45:25<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.List;

/**
 * ClassName: RspSlotDetailDto <br/>
 * date: 2016年10月14日 上午9:45:26 <br/>
 * .
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
@ApiModel
public class RspSlotBackendDetailDto implements Serializable {

    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID = -7999309449154634481L;

    /** 广告位ID. */
    @ApiModelProperty(value = "广告位ID")
    private Long              slotId;

    /**
     * 是否开启标题算法，默认0不开启，1开启
     */
    @ApiModelProperty(value = "是否开启标题算法，默认0不开启，1开启")
    private Integer isAlgoTitle;
    /**
     * 标题算法占比，大于等于100就全走
     */
    @ApiModelProperty(value = "标题算法占比，大于等于100就全走")
    private Integer algoTitleRate;

    public Integer getIsAlgoTitle() {
        return isAlgoTitle;
    }

    public void setIsAlgoTitle(Integer isAlgoTitle) {
        this.isAlgoTitle = isAlgoTitle;
    }

    public Integer getAlgoTitleRate() {
        return algoTitleRate;
    }

    public void setAlgoTitleRate(Integer algoTitleRate) {
        this.algoTitleRate = algoTitleRate;
    }

    /** 广告位名称. */
    @ApiModelProperty(value = "广告位名称")
    private String            slotName;

    /** 广告位类型. */
    @ApiModelProperty(value = "广告位类型")
    private Integer           slotType;

    /** 媒体ID. */
    @ApiModelProperty(value = "媒体ID")
    private Long              appId;

    /** 媒体名称. */
    @ApiModelProperty(value = "媒体名称")
    private String            appName;

    /** 主图尺寸 0-600*300 1-600*500 2-640*270 3-960*640 4-800*120. */
    @ApiModelProperty(value = "主图尺寸 0-600*300 1-600*500 2-640*270 3-960*640 4-800*120")
    private Integer           pictureSize;

    /** 广告信息流类型 */
    @ApiModelProperty(value = "广告信息流类型")
    private Integer           flowType;

    /** 屏蔽策略ID. */
    @ApiModelProperty(value = "屏蔽策略ID")
    private Long              strategyId;

    /** 屏蔽策略名称. */
    @ApiModelProperty(value = "屏蔽策略名称")
    private String            strategyName;

    /** 屏蔽行业. */
    @ApiModelProperty(value = "屏蔽行业")
    private List<TagLevel>    shieldIndustries;

    /** 屏蔽广告主. */
    @ApiModelProperty(value = "屏蔽广告主")
    private List<String>      shieldAdvertisers;

    /** 屏蔽广告列表. */
    @ApiModelProperty(value = "屏蔽广告列表")
    private List<TagLevel>    advertTagNums;

    /** 屏蔽活动标签列表 */
    @ApiModelProperty(value = "屏蔽活动标签列表")
    private List<TagLevel>    shieldActivitys;

    /** The industry flag. */
    private boolean           industryFlag      = false;

    /** The advertiser flag. */
    private boolean           advertiserFlag    = false;

    /** The advertTagNums flag. */
    private boolean           advertTagNumsFlag = false;

    /** The activitys flag. */
    private boolean           activitysFlag     = false;

    /** 广告位曝光上限 */
    @ApiModelProperty(value = "广告位曝光上限")
    private Integer           slotExposeLimit;

    /** 活动曝光上限 */
    @ApiModelProperty(value = "活动曝光上限")
    private Integer           activityExposeLimit;

    /** 手动投放时的活动投放地址. */
    @ApiModelProperty(value = "手动投放时的活动投放地址")
    private String            activityUrl;

    /** 手动投放时的活动投放目标地址. */
    @ApiModelProperty(value = "手动投放时的活动投放目标地址")
    private String            activityTargetUrl;

    /** 小图标是否可见. */
    @ApiModelProperty(value = "小图标是否可见")
    private boolean           isVisibleOfIco;

    /** 关闭按钮是否可见. */
    @ApiModelProperty(value = "关闭按钮是否可见")
    private boolean           isVisibleOfCloseButton;

    /** 关联规格ID */
    @ApiModelProperty(value = "关联规格ID")
    private Long              msId;
    /** 关联规格名称 */
    @ApiModelProperty(value = "关联规格名称")
    private String            msName;

    /**素材规格类型 0:图片 1:文字*/
    @ApiModelProperty(value = "素材规格类型 0:图片 1:文字")
    private Integer           msType;

    /** 是否拦截返回操作(1:拦截，0:不拦截). */
    @ApiModelProperty(value = "是否拦截返回操作(1:拦截，0:不拦截)")
    private Boolean           isReturn;

    /** 拦截返回操作频次. */
    @ApiModelProperty(value = "拦截返回操作频次")
    private Integer           numReturn;

    /** 返回拦截类型(0:返回拦截页面，1:更多福利弹层, 2:再来一次弹层) */
    @ApiModelProperty(value = "返回拦截类型(0:返回拦截页面，1:更多福利弹层, 2:再来一次弹层)")
    private Integer           returnType;

    /** 每次拦截返回次数. */
    @ApiModelProperty(value = "每次拦截返回次数")
    private Integer           timesReturn;

    /** 推荐位弹层开关(1:开，0:关). */
    @ApiModelProperty(value = "推荐位弹层开关(1:开，0:关)")
    private Boolean           isRecommend;

    /** 广告位投放方式 */
    @ApiModelProperty(value = "广告位投放方式")
    private Integer           activityPutWay;

    /** sdk版本list */
    @ApiModelProperty(value = "sdk版本list")
    private List<String>      sdkVersions;

    /** sdk来源信息list */
    @ApiModelProperty(value = "sdk来源信息list")
    private List<String>      sdkSources;

    /** sdk类型 */
    @ApiModelProperty(value = "sdk类型")
    private String            sdkType;

    /** app 审核状态 */
    @ApiModelProperty(value = "app 审核状态")
    private Integer           appStatus;

    /** 广告位定向模式 1：仅投放定向列表 2：优先投放定向列表 */
    @ApiModelProperty(value = "广告位定向模式 1：仅投放定向列表 2：优先投放定向列表")
    private Integer           directMode;

    /** 管理端屏蔽策略标签 */
    @ApiModelProperty(value = "管理端屏蔽策略标签")
    private Long              managerStrategyId;

    /** 来源域名屏蔽策略名称 */
    @ApiModelProperty(value = "来源域名屏蔽策略名称")
    private List<String>      shieldName;

    /** 媒体平台 */
    @ApiModelProperty(value = "媒体平台")
    private String            platform;

    @ApiModelProperty(value = "广告位说明")
    private String            remark;

    @ApiModelProperty(value = "广告位图片")
    private List<String>      remarkImgs;
    // 广告位性质标签标题
    @ApiModelProperty(value = "广告位性质标签标题")
    private String            tagName;

    @ApiModelProperty(value = "广告位性质标签Id")
    private Long            tagId;

    /** 广告位性质. */
    @ApiModelProperty(value = "广告位性质")
    private List<TagItem>    slotPropertyTags;

    /** 客服状态 */
    @ApiModelProperty(value = "客服状态")
    private Integer           isShowService;

    /** 客服电话是否自定义(1:自定义，0:默认). */
    @ApiModelProperty(value = "客服电话是否自定义(1:自定义，0:默认)")
    private Integer            isServicePhone;

    /**自定义客服电话 */
    @ApiModelProperty(value = "自定义客服电话")
    private String             servicePhone;

    /** 奖品页客服开关(1:开，0:关). */
    @ApiModelProperty(value = "奖品页客服开关(1:开，0:关)")
    private Integer            isPrizeShowService;

    /** 奖品页客服电话是否自定义(1:自定义，0:默认). */
    @ApiModelProperty(value = "奖品页客服电话是否自定义(1:自定义，0:默认)")
    private Integer            isPrizeServicePhone;

    /**自定义奖品页客服电话 */
    @ApiModelProperty(value = "自定义奖品页客服电话")
    private String             prizeServicePhone;

    /** 客服状态样式ID */
    @ApiModelProperty(value = "客服状态样式ID")
    private Long              showServiceId;
    /**客服状态样式名称 */
    @ApiModelProperty(value = "客服状态样式名称")
    private String            showServiceName;
    /** 普通插件状态 0 开 1 关 */
    @ApiModelProperty(value = "普通插件状态 0 开 1 关")
    private Integer           commonPlugStatus;
    /** 响应式插件状态 0 开 1 关 */
    @ApiModelProperty(value = "响应式插件状态 0 开 1 关")
    private Integer           rspPlugStatus;
    /** 插件优先级 */
    @ApiModelProperty(value = "插件优先级")
    private Integer           rspPlugLevel;
    /** 响应式插件次数 */
    @ApiModelProperty(value = "响应式插件次数")
    private Integer           rspPlugCount;
    /** 响应式插件Id集合 */
    @ApiModelProperty(value = "响应式插件Id集合")
    private List<Long>        rspPlugIds;
    /** 定时插件状态 0 开 1 关 */
    @ApiModelProperty(value = "定时插件状态 0 开 1 关")
    private Integer           timingPlugStatus;
    /** 定时插件Id集合 */
    @ApiModelProperty(value = "定时插件Id集合")
    private List<Long>        timingPlugIds;
    /** 浮标状态 0 开 1 关 */
    @ApiModelProperty(value = "浮标状态 0 开 1 关")
    private Integer           buoyStatus;
    /** 触发浮标次数 */
    @ApiModelProperty(value = "触发浮标次数")
    private Integer           buoyCount;
    /** 浮标请求类型 */
    @ApiModelProperty(value = "浮标请求类型")
    private Integer           buoyRequestType;
    /** 下拉状态 0 开 1 关  */
    @ApiModelProperty(value = "下拉状态 0 开 1 关")
    private Integer           pullBuoyStatus;
    /** 下拉触发次数*/
    @ApiModelProperty(value = "下拉触发次数")
    private Integer           pullBuoyCount;
    /** 流量分配开关：0关闭，1打开 **/
    @ApiModelProperty(value = "流量分配开关：0关闭，1打开")
    private Integer flowStatus;
    /** '测试计划状态: 0-关闭 1-开启 2-结束', **/
    @ApiModelProperty(value = "测试计划状态: 0-关闭 1-开启 2-结束")
    private Integer planStatus;
    /** 分配流量比例 **/
    @ApiModelProperty(value = "分配流量比例")
    private Integer ratio;
    /** 手机账号开关 */
    @ApiModelProperty(value = "手机账号开关")
    private Integer           phoneStatus;
    /** 中奖推荐开关：0关闭，1打开 **/
    @ApiModelProperty(value = "中奖推荐开关：0关闭，1打开")
    private Integer isPrizeRecommend;
    /** 中奖公示开关 0关闭 1开启 **/
    @ApiModelProperty(value = "中奖公示开关 0关闭 1开启")
    private Integer isPrizePublicity;
    /** 中奖公示样式id **/
    @ApiModelProperty(value = "中奖公示样式id")
    private Long publicityId;
    /** 返回拦截区域屏蔽开关 0 开 1 关 */
    @ApiModelProperty(value = "返回拦截区域屏蔽开关 0 开 1 关")
    private Integer returnRegionStatus;
    /**
     * 返回拦截可用区域Id集合
     */
    @ApiModelProperty(value = "返回拦截可用区域Id集合")
    private List<Long> returnValidRegionIds;
    /** 插件投放区域屏蔽开关 0 开 1 关 */
    @ApiModelProperty(value = "插件投放区域屏蔽开关 0 开 1 关")
    private Integer pluginRegionStatus;
    /**
     * 插件投放可用区域Id集合
     */
    @ApiModelProperty(value = "插件投放可用区域Id集合")
    private List<Long> pluginValidRegionIds;

    /**用户登录类型，0：活动免登，1：手机号登录，2：wx登录，3：媒体用户登录*/
    @ApiModelProperty(value = "用户登录类型，0：活动免登，1：手机号登录，2：wx登录，3：媒体用户登录")
    private Integer loginType;
    /**金币来源，0：推啊金币，1：媒体自有金币*/
    @ApiModelProperty(value = "金币来源，0：推啊金币，1：媒体自有金币")
    private Integer moneySource;

    @ApiModelProperty(value = "金币汇率")
    private String moneyRate;

    @ApiModelProperty(value = "第三方扣金币接口")
    private String thirdInterface;

    @ApiModelProperty(value = "媒体虚拟货币查询接口")
    private String thirdPage;
    /**
     *  媒体虚拟金币名称
     */
    @ApiModelProperty(value = "媒体虚拟金币名称")
    private String thirdMoneyName;
    /**
     * 我们游戏内金币单位
     */
    @ApiModelProperty(value = "我们游戏内金币单位")
    private String moneyName;

    /**
     * 货币同步方式（0|NULL ： 弹窗兑换；1：自动兑换）
     */
    @ApiModelProperty(value = "货币同步方式（0|NULL ： 弹窗兑换；1：自动兑换）")
    private Integer cashTransferWay;

    /** 激励开关(0-关闭，1-默认，2-自定义) */
    @ApiModelProperty(value = "激励开关(0-关闭，1-默认，2-自定义)")
    private Integer incentiveSwitch;

    /** 开启激励配置时是否返回拦截红包雨，1：是，0：否--不触发增值 */
    @ApiModelProperty(value = "开启激励配置时是否返回拦截红包雨，1：是，0：否--不触发增值")
    private Integer incentiveIntercept;

    /** 激励总金额 */
    @ApiModelProperty(value = "激励总金额")
    private String incentiveAmount;

    /** 激励总次数 */
    @ApiModelProperty(value = "激励总次数")
    private Integer incentiveTimes;

    /** 激励时机 */
    @ApiModelProperty(value = "激励时机")
    private String incentiveMoment;

    /** 提现跳转链接 */
    @ApiModelProperty(value = "提现跳转链接")
    private String withdrawUrl;

    /** 接入广告类型 0-互动广告 1-展示广告 2-原生互动广告位*/
    @ApiModelProperty(value = "接入广告类型 0-互动广告 1-展示广告 2-原生互动广告位")
    private Integer slotAccessType;

    /** 接入类型 0-默认方式 1-jssdk 2-sdk */
    @ApiModelProperty(value = "接入类型 0-默认方式 1-jssdk 2-sdk")
    private Integer joinInType;

    /**广告位白名单开启状态 0-关闭 1-开启*/
    @ApiModelProperty(value = "广告位白名单开启状态 0-关闭 1-开启")
    private Integer openWhiteList;

    /**
     *   广告角标    tinyint  默认关闭0  , 1开启
     */
    @ApiModelProperty(value = "广告角标    tinyint  默认关闭0  , 1开启")
    private Integer isShowAd ;

    /**
     * 承办声明开关   默认为0，1开启
     */
    @ApiModelProperty(value = "承办声明开关   默认为0，1开启")
    private Integer undertakeStateSwitch ;

    /** 广告位活动皮肤标签屏蔽 */
    @ApiModelProperty(value = "广告位活动皮肤标签屏蔽")
    private List<String> shieldActivitySkinTags;

    /**
     * 承办声明内容
     */
    @ApiModelProperty(value = "承办声明内容")
    private String undertakeStateContext ;

    /**
     * 承办声明内容
     */
    @ApiModelProperty(value = "承办声明内容(格式化)")
    private String undertakeStateContextFormat ;

    /**
     * 是否将白名单同步到流量策略
     **/
    @ApiModelProperty(value = "是否将白名单同步到流量策略")
    private Integer isSyncWhiteList;

    /**
     * 详情页客服电话
     **/
    @ApiModelProperty(value = "详情页客服电话")
    private Integer showDetailPhone;

    /** 是否开启奖品算法，默认0不开启，1开启 */
    @ApiModelProperty(value = "是否开启奖品算法，默认0不开启，1开启")
    private Integer isAlgoPrize;

    /** 奖品算法占比，大于等于100就全走 */
    @ApiModelProperty(value = "奖品算法占比，大于等于100就全走")
    private Integer algoPrizeRate;

    /**
     * 是否支持互动活动打底
     */
    @ApiModelProperty(value = "是否支持互动活动打底")
    private Integer supportDownGrade;

    /** 广告位开启黑名单 */
    @ApiModelProperty(value = "广告位开启黑名单")
    private Integer openBlackList;

    /** 0-同步到流量策略,1-同步到全局 */
    @ApiModelProperty(value = "0-同步到流量策略,1-同步到全局 ")
    private Integer isSyncBlackList;

    /** 1-活动弹层关闭拦截开关开启，0-活动弹层关闭拦截开关关闭 */
    @ApiModelProperty(value = " 1-活动弹层关闭拦截开关开启，0-活动弹层关闭拦截开关关闭")
    private Integer isLayerCloseIntercept;

    /** 客服按钮 默认开（1-开，0-关） */
    @ApiModelProperty(value = "客服按钮 默认开（1-开，0-关）")
    private Integer orderServiceSwitch;

    /** 是否只支持svga格式素材。0-关闭，1-开启 */
    @ApiModelProperty(value = "是否只支持svga格式素材。0-关闭，1-开启")
    private Integer bindSvga;

    /** 广告位类型 **/
    @ApiModelProperty(value = "广告位类型")
    private Integer sceneType;

    /** 唤醒广告是否开启 0-关闭 1-开启 */
    private Integer deeplinkStatus;

    /** 投放素材类型 1:图片，2:图片+标题,3:活动,4:描述,5:标题 6：不使用素材 **/
    private Integer  sckType;

    /**
     * 广告位链接宏替换开关。0-关，1-开
     */
    private Integer tuParamStatus;
    /** 唤醒广告蒙层是否开启 0-关闭 1-开启(默认) */
    private Integer deeplinkLayer;

    // 信息流规格模板类型 0=自定义、1=上文下图、2=左文右图、3=左图右文、4=三图
    private Integer templateType;

    public Integer getIsLayerCloseIntercept() {
        return isLayerCloseIntercept;
    }

    public void setIsLayerCloseIntercept(Integer isLayerCloseIntercept) {
        this.isLayerCloseIntercept = isLayerCloseIntercept;
    }

    public Integer getIsAlgoPrize() {
        return isAlgoPrize;
    }

    public void setIsAlgoPrize(Integer isAlgoPrize) {
        this.isAlgoPrize = isAlgoPrize;
    }

    public Integer getAlgoPrizeRate() {
        return algoPrizeRate;
    }

    public void setAlgoPrizeRate(Integer algoPrizeRate) {
        this.algoPrizeRate = algoPrizeRate;
    }

    public Integer getOpenWhiteList() {
        return openWhiteList;
    }

    public void setOpenWhiteList(Integer openWhiteList) {
        this.openWhiteList = openWhiteList;
    }

    public Integer getCashTransferWay() {
        return cashTransferWay;
    }

    public void setCashTransferWay(Integer cashTransferWay) {
        this.cashTransferWay = cashTransferWay;
    }

    public Integer getLoginType() {
        return loginType;
    }

    public void setLoginType(Integer loginType) {
        this.loginType = loginType;
    }

    public Integer getMoneySource() {
        return moneySource;
    }

    public void setMoneySource(Integer moneySource) {
        this.moneySource = moneySource;
    }

    public String getMoneyRate() {
        return moneyRate;
    }

    public void setMoneyRate(String moneyRate) {
        this.moneyRate = moneyRate;
    }

    public String getThirdInterface() {
        return thirdInterface;
    }

    public void setThirdInterface(String thirdInterface) {
        this.thirdInterface = thirdInterface;
    }

    public String getThirdPage() {
        return thirdPage;
    }

    public void setThirdPage(String thirdPage) {
        this.thirdPage = thirdPage;
    }

    public Integer getTimingPlugStatus() {
        return timingPlugStatus;
    }

    public void setTimingPlugStatus(Integer timingPlugStatus) {
        this.timingPlugStatus = timingPlugStatus;
    }

    public Integer getCommonPlugStatus() {
        return commonPlugStatus;
    }

    public void setCommonPlugStatus(Integer commonPlugStatus) {
        this.commonPlugStatus = commonPlugStatus;
    }

    public Integer getRspPlugStatus() {
        return rspPlugStatus;
    }

    public void setRspPlugStatus(Integer rspPlugStatus) {
        this.rspPlugStatus = rspPlugStatus;
    }

    public Integer getRspPlugCount() {
        return rspPlugCount;
    }

    public void setRspPlugCount(Integer rspPlugCount) {
        this.rspPlugCount = rspPlugCount;
    }

    public List<Long> getRspPlugIds() {
        return rspPlugIds;
    }

    public void setRspPlugIds(List<Long> rspPlugIds) {
        this.rspPlugIds = rspPlugIds;
    }

    public List<Long> getTimingPlugIds() {
        return timingPlugIds;
    }

    public void setTimingPlugIds(List<Long> timingPlugIds) {
        this.timingPlugIds = timingPlugIds;
    }

    public Integer getBuoyStatus() {
        return buoyStatus;
    }

    public void setBuoyStatus(Integer buoyStatus) {
        this.buoyStatus = buoyStatus;
    }

    public Integer getBuoyCount() {
        return buoyCount;
    }

    public void setBuoyCount(Integer buoyCount) {
        this.buoyCount = buoyCount;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public List<String> getRemarkImgs() {
        return remarkImgs;
    }

    public void setRemarkImgs(List<String> remarkImgs) {
        this.remarkImgs = remarkImgs;
    }

    public Integer getIsShowAd() {
        return isShowAd;
    }

    public void setIsShowAd(Integer isShowAd) {
        this.isShowAd = isShowAd;
    }

    public Integer getUndertakeStateSwitch() {
        return undertakeStateSwitch;
    }

    public void setUndertakeStateSwitch(Integer undertakeStateSwitch) {
        this.undertakeStateSwitch = undertakeStateSwitch;
    }

    public String getUndertakeStateContext() {
        return undertakeStateContext;
    }

    public void setUndertakeStateContext(String undertakeStateContext) {
        this.undertakeStateContext = undertakeStateContext;
    }

    /**
     * industryFlag.
     *
     * @return the industryFlag
     * @since JDK 1.6
     */
    public boolean isIndustryFlag() {
        return industryFlag;
    }

    /**
     * industryFlag.
     *
     * @param industryFlag the industryFlag to set
     * @since JDK 1.6
     */
    public void setIndustryFlag(boolean industryFlag) {
        this.industryFlag = industryFlag;
    }

    /**
     * advertiserFlag.
     *
     * @return the advertiserFlag
     * @since JDK 1.6
     */
    public boolean isAdvertiserFlag() {
        return advertiserFlag;
    }

    /**
     * advertiserFlag.
     *
     * @param advertiserFlag the advertiserFlag to set
     * @since JDK 1.6
     */
    public void setAdvertiserFlag(boolean advertiserFlag) {
        this.advertiserFlag = advertiserFlag;
    }

    /**
     * slotType.
     *
     * @return the slotType
     * @since JDK 1.6
     */
    public Integer getSlotType() {
        return slotType;
    }

    /**
     * slotType.
     *
     * @param slotType the slotType to set
     * @since JDK 1.6
     */
    public void setSlotType(Integer slotType) {
        this.slotType = slotType;
    }

    /**
     * slotId.
     *
     * @return the slotId
     * @since JDK 1.6
     */
    public Long getSlotId() {
        return slotId;
    }

    /**
     * slotId.
     *
     * @param slotId the slotId to set
     * @since JDK 1.6
     */
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    /**
     * slotName.
     *
     * @return the slotName
     * @since JDK 1.6
     */
    public String getSlotName() {
        return slotName;
    }

    /**
     * slotName.
     *
     * @param slotName the slotName to set
     * @since JDK 1.6
     */
    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    /**
     * appId.
     *
     * @return the appId
     * @since JDK 1.6
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * appId.
     *
     * @param appId the appId to set
     * @since JDK 1.6
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * appName.
     *
     * @return the appName
     * @since JDK 1.6
     */
    public String getAppName() {
        return appName;
    }

    /**
     * appName.
     *
     * @param appName the appName to set
     * @since JDK 1.6
     */
    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * pictureSize.
     *
     * @return the pictureSize
     * @since JDK 1.6
     */
    public Integer getPictureSize() {
        return pictureSize;
    }

    /**
     * pictureSize.
     *
     * @param pictureSize the pictureSize to set
     * @since JDK 1.6
     */
    public void setPictureSize(Integer pictureSize) {
        this.pictureSize = pictureSize;
    }

    /**
     * strategyId.
     *
     * @return the strategyId
     * @since JDK 1.6
     */
    public Long getStrategyId() {
        return strategyId;
    }

    /**
     * strategyId.
     *
     * @param strategyId the strategyId to set
     * @since JDK 1.6
     */
    public void setStrategyId(Long strategyId) {
        this.strategyId = strategyId;
    }

    /**
     * strategyName.
     *
     * @return the strategyName
     * @since JDK 1.6
     */
    public String getStrategyName() {
        return strategyName;
    }

    /**
     * strategyName.
     *
     * @param strategyName the strategyName to set
     * @since JDK 1.6
     */
    public void setStrategyName(String strategyName) {
        this.strategyName = strategyName;
    }

    /**
     * shieldIndustries.
     *
     * @return the shieldIndustries
     * @since JDK 1.6
     */
    public List<TagLevel> getShieldIndustries() {
        return shieldIndustries;
    }

    /**
     * shieldIndustries.
     *
     * @param shieldIndustries the shieldIndustries to set
     * @since JDK 1.6
     */
    public void setShieldIndustries(List<TagLevel> shieldIndustries) {
        this.shieldIndustries = shieldIndustries;
    }

    /**
     * shieldAdvertisers.
     *
     * @return the shieldAdvertisers
     * @since JDK 1.6
     */
    public List<String> getShieldAdvertisers() {
        return shieldAdvertisers;
    }

    /**
     * shieldAdvertisers.
     *
     * @param shieldAdvertisers the shieldAdvertisers to set
     * @since JDK 1.6
     */
    public void setShieldAdvertisers(List<String> shieldAdvertisers) {
        this.shieldAdvertisers = shieldAdvertisers;
    }

    /**
     * advertTagNums.
     *
     * @return the advertTagNums
     * @since JDK 1.6
     */
    public List<TagLevel> getAdvertTagNums() {
        return advertTagNums;
    }

    /**
     * advertTagNums.
     *
     * @param advertTagNums the advertTagNums to set
     * @since JDK 1.6
     */
    public void setAdvertTagNums(List<TagLevel> advertTagNums) {
        this.advertTagNums = advertTagNums;
    }

    /**
     * flowType.
     *
     * @return the flowType
     * @since JDK 1.6
     */
    public Integer getFlowType() {
        return flowType;
    }

    /**
     * flowType.
     *
     * @param flowType the flowType to set
     * @since JDK 1.6
     */
    public void setFlowType(Integer flowType) {
        this.flowType = flowType;
    }

    /**
     * advertTagNumsFlag.
     *
     * @return the advertTagNumsFlag
     * @since JDK 1.6
     */
    public boolean isAdvertTagNumsFlag() {
        return advertTagNumsFlag;
    }

    /**
     * advertTagNumsFlag.
     *
     * @param advertTagNumsFlag the advertTagNumsFlag to set
     * @since JDK 1.6
     */
    public void setAdvertTagNumsFlag(boolean advertTagNumsFlag) {
        this.advertTagNumsFlag = advertTagNumsFlag;
    }

    public Integer getSlotExposeLimit() {
        return slotExposeLimit;
    }

    public void setSlotExposeLimit(Integer slotExposeLimit) {
        this.slotExposeLimit = slotExposeLimit;
    }

    public Integer getActivityExposeLimit() {
        return activityExposeLimit;
    }

    public void setActivityExposeLimit(Integer activityExposeLimit) {
        this.activityExposeLimit = activityExposeLimit;
    }

    public String getActivityUrl() {
        return activityUrl;
    }

    public void setActivityUrl(String activityUrl) {
        this.activityUrl = activityUrl;
    }

    public String getActivityTargetUrl() {
        return activityTargetUrl;
    }

    public void setActivityTargetUrl(String activityTargetUrl) {
        this.activityTargetUrl = activityTargetUrl;
    }

    public boolean isVisibleOfIco() {
        return isVisibleOfIco;
    }

    public void setVisibleOfIco(boolean visibleOfIco) {
        isVisibleOfIco = visibleOfIco;
    }

    public boolean isVisibleOfCloseButton() {
        return isVisibleOfCloseButton;
    }

    public void setVisibleOfCloseButton(boolean visibleOfCloseButton) {
        isVisibleOfCloseButton = visibleOfCloseButton;
    }

    public Long getMsId() {
        return msId;
    }

    public void setMsId(Long msId) {
        this.msId = msId;
    }

    public String getMsName() {
        return msName;
    }

    public void setMsName(String msName) {
        this.msName = msName;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);

    }

    public Boolean getIsReturn() {
        return isReturn;
    }

    public void setIsReturn(Boolean isReturn) {
        this.isReturn = isReturn;
    }

    public Integer getNumReturn() {
        return numReturn;
    }

    public void setNumReturn(Integer numReturn) {
        this.numReturn = numReturn;
    }

    public Integer getTimesReturn() {
        return timesReturn;
    }

    public void setTimesReturn(Integer timesReturn) {
        this.timesReturn = timesReturn;
    }

    public Boolean getIsRecommend() {
        return isRecommend;
    }

    public void setIsRecommend(Boolean isRecommend) {
        this.isRecommend = isRecommend;
    }

    public Integer getActivityPutWay() {
        return activityPutWay;
    }

    public void setActivityPutWay(Integer activityPutWay) {
        this.activityPutWay = activityPutWay;
    }

    public List<String> getSdkVersions() {
        return sdkVersions;
    }

    public void setSdkVersions(List<String> sdkVersions) {
        this.sdkVersions = sdkVersions;
    }

    public List<String> getSdkSources() {
        return sdkSources;
    }

    public void setSdkSources(List<String> sdkSources) {
        this.sdkSources = sdkSources;
    }

    public String getSdkType() {
        return sdkType;
    }

    public void setSdkType(String sdkType) {
        this.sdkType = sdkType;
    }

    public Integer getAppStatus() {
        return appStatus;
    }

    public void setAppStatus(Integer appStatus) {
        this.appStatus = appStatus;
    }

    public Integer getDirectMode() {
        return directMode;
    }

    public void setDirectMode(Integer directMode) {
        this.directMode = directMode;
    }

    public List<TagLevel> getShieldActivitys() {
        return shieldActivitys;
    }

    public void setShieldActivitys(List<TagLevel> shieldActivitys) {
        this.shieldActivitys = shieldActivitys;
    }

    public boolean isActivitysFlag() {
        return activitysFlag;
    }

    public void setActivitysFlag(boolean activitysFlag) {
        this.activitysFlag = activitysFlag;
    }

    public Long getManagerStrategyId() {
        return managerStrategyId;
    }

    public void setManagerStrategyId(Long managerStrategyId) {
        this.managerStrategyId = managerStrategyId;
    }

    public List<String> getShieldName() {
        return shieldName;
    }

    public void setShieldName(List<String> shieldName) {
        this.shieldName = shieldName;
    }

    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getTagName() {
        return tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public Long getTagId() {
        return tagId;
    }

    public void setTagId(Long tagId) {
        this.tagId = tagId;
    }

    public List<TagItem> getSlotPropertyTags() {
        return slotPropertyTags;
    }

    public void setSlotPropertyTags(List<TagItem> slotPropertyTags) {
        this.slotPropertyTags = slotPropertyTags;
    }

    public Integer getIsShowService() {
        return isShowService;
    }

    public void setIsShowService(Integer isShowService) {
        this.isShowService = isShowService;
    }

    public Integer getRspPlugLevel() {
        return rspPlugLevel;
    }

    public void setRspPlugLevel(Integer rspPlugLevel) {
        this.rspPlugLevel = rspPlugLevel;
    }

    public Integer getFlowStatus() {
        return flowStatus;
    }

    public void setFlowStatus(Integer flowStatus) {
        this.flowStatus = flowStatus;
    }

    public Integer getPlanStatus() {
        return planStatus;
    }

    public void setPlanStatus(Integer planStatus) {
        this.planStatus = planStatus;
    }

    public Integer getRatio() {
        return ratio;
    }

    public void setRatio(Integer ratio) {
        this.ratio = ratio;
    }
    public Long getShowServiceId() {
        return showServiceId;
    }

    public void setShowServiceId(Long showServiceId) {
        this.showServiceId = showServiceId;
    }

    public String getShowServiceName() {
        return showServiceName;
    }

    public void setShowServiceName(String showServiceName) {
        this.showServiceName = showServiceName;
    }

    public Integer getPhoneStatus() {
        return phoneStatus;
    }

    public void setPhoneStatus(Integer phoneStatus) {
        this.phoneStatus = phoneStatus;
    }

    public Integer getIsPrizeRecommend() {
        return isPrizeRecommend;
    }

    public void setIsPrizeRecommend(Integer isPrizeRecommend) {
        this.isPrizeRecommend = isPrizeRecommend;
    }

    public Integer getIsPrizePublicity() {
        return isPrizePublicity;
    }

    public void setIsPrizePublicity(Integer isPrizePublicity) {
        this.isPrizePublicity = isPrizePublicity;
    }

    public Long getPublicityId() {
        return publicityId;
    }

    public void setPublicityId(Long publicityId) {
        this.publicityId = publicityId;
    }

    public Integer getReturnRegionStatus() {
        return returnRegionStatus;
    }

    public void setReturnRegionStatus(Integer returnRegionStatus) {
        this.returnRegionStatus = returnRegionStatus;
    }

    public List<Long> getReturnValidRegionIds() {
        return returnValidRegionIds;
    }

    public void setReturnValidRegionIds(List<Long> returnValidRegionIds) {
        this.returnValidRegionIds = returnValidRegionIds;
    }

    public Integer getPluginRegionStatus() {
        return pluginRegionStatus;
    }

    public void setPluginRegionStatus(Integer pluginRegionStatus) {
        this.pluginRegionStatus = pluginRegionStatus;
    }

    public List<Long> getPluginValidRegionIds() {
        return pluginValidRegionIds;
    }

    public void setPluginValidRegionIds(List<Long> pluginValidRegionIds) {
        this.pluginValidRegionIds = pluginValidRegionIds;
    }

    public Integer getMsType() {
        return msType;
    }

    public void setMsType(Integer msType) {
        this.msType = msType;
    }


    public String getThirdMoneyName() {
        return thirdMoneyName;
    }

    public void setThirdMoneyName(String thirdMoneyName) {
        this.thirdMoneyName = thirdMoneyName;
    }

    public String getMoneyName() {
        return moneyName;
    }

    public void setMoneyName(String moneyName) {
        this.moneyName = moneyName;
    }

    public Integer getPullBuoyStatus() {
        return pullBuoyStatus;
    }

    public void setPullBuoyStatus(Integer pullBuoyStatus) {
        this.pullBuoyStatus = pullBuoyStatus;
    }

    public Integer getPullBuoyCount() {
        return pullBuoyCount;
    }

    public void setPullBuoyCount(Integer pullBuoyCount) {
        this.pullBuoyCount = pullBuoyCount;
    }

    public Integer getIncentiveSwitch() {
        return incentiveSwitch;
    }

    public void setIncentiveSwitch(Integer incentiveSwitch) {
        this.incentiveSwitch = incentiveSwitch;
    }

    public String getIncentiveAmount() {
        return incentiveAmount;
    }

    public void setIncentiveAmount(String incentiveAmount) {
        this.incentiveAmount = incentiveAmount;
    }

    public Integer getIncentiveTimes() {
        return incentiveTimes;
    }

    public void setIncentiveTimes(Integer incentiveTimes) {
        this.incentiveTimes = incentiveTimes;
    }

    public String getIncentiveMoment() {
        return incentiveMoment;
    }

    public void setIncentiveMoment(String incentiveMoment) {
        this.incentiveMoment = incentiveMoment;
    }

    public String getWithdrawUrl() {
        return withdrawUrl;
    }

    public void setWithdrawUrl(String withdrawUrl) {
        this.withdrawUrl = withdrawUrl;
    }

    public Integer getSlotAccessType() {
        return slotAccessType;
    }

    public void setSlotAccessType(Integer slotAccessType) {
        this.slotAccessType = slotAccessType;
    }

    public Integer getIncentiveIntercept() {
        return incentiveIntercept;
    }

    public void setIncentiveIntercept(Integer incentiveIntercept) {
        this.incentiveIntercept = incentiveIntercept;
    }

    public Integer getReturnType() {
        return returnType;
    }

    public void setReturnType(Integer returnType) {
        this.returnType = returnType;
    }

    public Integer getBuoyRequestType() {
        return buoyRequestType;
    }

    public void setBuoyRequestType(Integer buoyRequestType) {
        this.buoyRequestType = buoyRequestType;
    }

    public Integer getJoinInType() {
        return joinInType;
    }

    public void setJoinInType(final Integer joinInType) {
        this.joinInType = joinInType;
    }

    public List<String> getShieldActivitySkinTags() {
        return shieldActivitySkinTags;
    }

    public void setShieldActivitySkinTags(List<String> shieldActivitySkinTags) {
        this.shieldActivitySkinTags = shieldActivitySkinTags;
    }

    public Integer getIsSyncWhiteList() {
        return isSyncWhiteList;
    }

    public void setIsSyncWhiteList(Integer isSyncWhiteList) {
        this.isSyncWhiteList = isSyncWhiteList;
    }

    public Integer getShowDetailPhone() {
        return showDetailPhone;
    }

    public void setShowDetailPhone(final Integer showDetailPhone) {
        this.showDetailPhone = showDetailPhone;
    }

    public Integer getSupportDownGrade() {
        return supportDownGrade;
    }

    public void setSupportDownGrade(Integer supportDownGrade) {
        this.supportDownGrade = supportDownGrade;
    }

    public Integer getOpenBlackList() {
        return openBlackList;
    }

    public void setOpenBlackList(final Integer openBlackList) {
        this.openBlackList = openBlackList;
    }

    public Integer getIsSyncBlackList() {
        return isSyncBlackList;
    }

    public void setIsSyncBlackList(final Integer isSyncBlackList) {
        this.isSyncBlackList = isSyncBlackList;
    }

    public Integer getIsServicePhone() {
        return isServicePhone;
    }

    public void setIsServicePhone(Integer isServicePhone) {
        this.isServicePhone = isServicePhone;
    }

    public String getServicePhone() {
        return servicePhone;
    }

    public void setServicePhone(String servicePhone) {
        this.servicePhone = servicePhone;
    }

    public Integer getIsPrizeShowService() {
        return isPrizeShowService;
    }

    public void setIsPrizeShowService(Integer isPrizeShowService) {
        this.isPrizeShowService = isPrizeShowService;
    }

    public Integer getIsPrizeServicePhone() {
        return isPrizeServicePhone;
    }

    public void setIsPrizeServicePhone(Integer isPrizeServicePhone) {
        this.isPrizeServicePhone = isPrizeServicePhone;
    }

    public String getPrizeServicePhone() {
        return prizeServicePhone;
    }

    public void setPrizeServicePhone(String prizeServicePhone) {
        this.prizeServicePhone = prizeServicePhone;
    }

    public Integer getOrderServiceSwitch() {
        return orderServiceSwitch;
    }

    public void setOrderServiceSwitch(Integer orderServiceSwitch) {
        this.orderServiceSwitch = orderServiceSwitch;
    }

    public Integer getBindSvga() {
        return bindSvga;
    }

    public void setBindSvga(Integer bindSvga) {
        this.bindSvga = bindSvga;
    }

    public Integer getSceneType() {
        return sceneType;
    }

    public void setSceneType(Integer sceneType) {
        this.sceneType = sceneType;
    }

    public Integer getDeeplinkStatus() {
        return deeplinkStatus;
    }

    public void setDeeplinkStatus(Integer deeplinkStatus) {
        this.deeplinkStatus = deeplinkStatus;
    }

    public Integer getSckType() {
        return sckType;
    }

    public void setSckType(Integer sckType) {
        this.sckType = sckType;
    }

    public Integer getTuParamStatus() {
        return tuParamStatus;
    }

    public void setTuParamStatus(Integer tuParamStatus) {
        this.tuParamStatus = tuParamStatus;
    }

    public Integer getDeeplinkLayer() {
        return deeplinkLayer;
    }

    public void setDeeplinkLayer(Integer deeplinkLayer) {
        this.deeplinkLayer = deeplinkLayer;
    }

    public Integer getTemplateType() {
        return templateType;
    }

    public void setTemplateType(Integer templateType) {
        this.templateType = templateType;
    }

    public String getUndertakeStateContextFormat() {
        return undertakeStateContextFormat;
    }

    public void setUndertakeStateContextFormat(String undertakeStateContextFormat) {
        this.undertakeStateContextFormat = undertakeStateContextFormat;
    }
}
