package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 外部评分规则广告位得分统计表
 * 
 * @author YWG.MID.P
 * @date 2020-09-28 07:29:06
 */
@Data
public class SlotExternalRewardStrategyStatisticsDTO implements Serializable {

	/**
	 * 主键
	 */
	private Long id;
	/**
	 * 账号ID
	 */
	private Long mediaId;
	/**
	 * 媒体ID
	 */
	private Long appId;
	/**
	 * 广告位ID
	 */
	private Long slotId;
	/**
	 * 日期
	 */
	private Date curDate;
	/**
	 * 打分规则（1:大盘默认 2:ADX媒体）
	 */
	private Integer type;
	/**
	 * 总分（百倍，最大值500）
	 */
	private Integer totalScore;
	/**
	 * 流量分（百倍，最大值500）
	 */
	private Integer flowScore;
	/**
	 * 价值性（百倍，最大值500）
	 */
	private Integer valueScore;
	/**
	 * 稳定性（百倍，最大值500）
	 */
	private Integer stableScore;
	/**
	 * 质量分（百倍，最大值500）
	 */
	private Integer qualityScore;
	/**
	 * 匹配度（百倍，最大值500）
	 */
	private Integer matchingScore;
	/**
	 * 影响力（百倍，最大值500）
	 */
	private Integer effectScore;
	/**
	 * 真实性（百倍，最大值500）
	 */
	private Integer truthScore;
	/**
	 * 变现能力（百倍，最大值500）
	 */
	private Integer cashoutScore;
	/**
	 * 创建时间
	 */
	private Date gmtCreate;
	/**
	 * 修改时间
	 */
	private Date gmtModified;

}
