package cn.com.duiba.tuia.ssp.center.api.dto.mediaapp;

import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

public class StatisticsDateCvrRsp implements Serializable {

    private static final long serialVersionUID = -4431793174644556892L;
    private Long buzId;

    /**
     * 开始日期
     */
    @ApiModelProperty(value = "开始日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "开始日期不能为空")
    private String            startDate;

    /**
     * 结束日期
     */
    @ApiModelProperty(value = "结束日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "结束日期不能为空")
    private String            endDate;

    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public Long getBuzId() {
        return buzId;
    }

    public void setBuzId(Long buzId) {
        this.buzId = buzId;
    }
}
