/**
 * Project Name:media-manager-biz File Name:ReqActivityStatisticsByPage.java Package
 * Name:cn.com.duiba.tuia.media.manager.model.req Date:2016年12月21日上午11:44:59 Copyright (c) 2016, duiba.com.cn All Rights
 * Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * ClassName:ReqActivityStatisticsByPage <br/>
 * Function: 活动数据统计. <br/>
 * Date: 2016年12月21日 上午11:44:59 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
@ApiModel
public class ReqActivitySlotDataByPage extends ReqPageQuery {

    /** 序列号. */
    private static final long serialVersionUID = -1158637634156561218L;

    /** 活动ID. */
    @ApiModelProperty(value = "活动ID", required = false)
    private Long              activityId;
    
    @ApiModelProperty(value = "活动Ids", required = false)
    private String activityIds; 
    
    @ApiModelProperty(value = "活动Id列表", required = false)
    private List<Long> activityIdList; 

	/** 媒体ID. */
    @ApiModelProperty(value = "媒体ID", required = false)
    private Long              appId;

    /** 媒体名称. */
    @ApiModelProperty(value = "媒体名称", required = false)
    private String            appName;

    /** 广告ID. */
    @ApiModelProperty(value = "广告ID", required = false)
    private Long              slotId;

    /** 广告名称. */
    @ApiModelProperty(value = "广告名称", required = false)
    private String            slotName;

    /** 广告类型. */
    @ApiModelProperty(value = "广告类型", required = false)
    private Integer           slotType;

    /** 媒体Id集合. */
    @ApiModelProperty(value = "媒体Ids", required = false)
    private List<Long>        appIds;

    /** 广告Id集合. */
    @ApiModelProperty(value = "广告Ids", required = false)
    private List<Long>        slotIds;

    /** 开始日期. */
    @ApiModelProperty(value = "开始日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "开始时间不能为空")
    private String            startDate;

    /** 结束日期. */
    @ApiModelProperty(value = "结束日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "结束时间不能为空")
    private String            endDate;

    /** The activity name. */
    @ApiModelProperty(value = "活动名称(用于导出)", required = false)
    private String            activityName;
    
    @ApiModelProperty(value = "活动来源", required = false)
    private Integer           source;

    @ApiModelProperty(value = "活动类型", required = false)
    private String           activityType;

    @ApiModelProperty(value = "导出方式", required = false)
    private Integer           exportType;//0是汇总，1是分日导出

    /**数据来源*/
    @ApiModelProperty(value = "数据来源", required = false)
    private Integer           dataSource;
    
    @ApiModelProperty(value = "广告位直投直投页、广告位直投主会场、直投页直投活动中心 ID", required = false)
    private Long             directId;
    
    @ApiModelProperty(value = "广告位直投直投页、广告位直投主会场、直投页直投活动中心 名称", required = false)
    private String           directName;

    @ApiModelProperty(value = "广告位性质id", required = false)
    private  Long tagId;

    @ApiModelProperty(value = "标签模块", required = false)
    private Integer    tagBlock;

    /**
     * 标签（多个标签用,分割，大类ID组别ID标签ID之间用-分割，如“5-21-249,5-20-252”）
     */
    @ApiModelProperty(value = "标签 大类ID-组别ID-标签ID")
    private String tagIds;
    
	public Integer getExportType() {
		return exportType;
	}

	public void setExportType(Integer exportType) {
		this.exportType = exportType;
	}

	/**
     * startDate.
     *
     * @return the startDate
     * @since JDK 1.6
     */
    public String getStartDate() {
        return startDate;
    }

    /**
     * startDate.
     *
     * @param startDate the startDate to set
     * @since JDK 1.6
     */
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    /**
     * endDate.
     *
     * @return the endDate
     * @since JDK 1.6
     */
    public String getEndDate() {
        return endDate;
    }

    /**
     * endDate.
     *
     * @param endDate the endDate to set
     * @since JDK 1.6
     */
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    /**
     * activityId.
     *
     * @return the activityId
     * @since JDK 1.6
     */
    public Long getActivityId() {
        return activityId;
    }

    /**
     * activityId.
     *
     * @param activityId the activityId to set
     * @since JDK 1.6
     */
    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }
    
    public String getActivityIds() {
		return activityIds;
	}

	public void setActivityIds(String activityIds) {
		this.activityIds = activityIds;
	}

    /**
     * appId.
     *
     * @return the appId
     * @since JDK 1.6
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * appId.
     *
     * @param appId the appId to set
     * @since JDK 1.6
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * slotId.
     *
     * @return the slotId
     * @since JDK 1.6
     */
    public Long getSlotId() {
        return slotId;
    }

    /**
     * slotId.
     *
     * @param slotId the slotId to set
     * @since JDK 1.6
     */
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    /**
     * appName.
     *
     * @return the appName
     * @since JDK 1.6
     */
    public String getAppName() {
        return appName;
    }

    /**
     * appName.
     *
     * @param appName the appName to set
     * @since JDK 1.6
     */
    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * slotName.
     *
     * @return the slotName
     * @since JDK 1.6
     */
    public String getSlotName() {
        return slotName;
    }

    /**
     * slotName.
     *
     * @param slotName the slotName to set
     * @since JDK 1.6
     */
    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    /**
     * slotType.
     *
     * @return the slotType
     * @since JDK 1.6
     */
    public Integer getSlotType() {
        return slotType;
    }

    /**
     * slotType.
     *
     * @param slotType the slotType to set
     * @since JDK 1.6
     */
    public void setSlotType(Integer slotType) {
        this.slotType = slotType;
    }

    /**
     * appIds.
     *
     * @return the appIds
     * @since JDK 1.6
     */
    public List<Long> getAppIds() {
        return appIds;
    }

    /**
     * appIds.
     *
     * @param appIds the appIds to set
     * @since JDK 1.6
     */
    public void setAppIds(List<Long> appIds) {
        this.appIds = appIds;
    }

    /**
     * slotIds.
     *
     * @return the slotIds
     * @since JDK 1.6
     */
    public List<Long> getSlotIds() {
        return slotIds;
    }

    /**
     * slotIds.
     *
     * @param slotIds the slotIds to set
     * @since JDK 1.6
     */
    public void setSlotIds(List<Long> slotIds) {
        this.slotIds = slotIds;
    }

    /**
     * Gets the activity name.
     *
     * @return the activity name
     */
    public String getActivityName() {
        return activityName;
    }

    /**
     * Sets the activity name.
     *
     * @param activityName the activity name
     */
    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }
    
    public Integer getSource() {
        return source;
    }

    
    public void setSource(Integer source) {
        this.source = source;
    }

    public String getActivityType() {
        return activityType;
    }

    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }
    
    public List<Long> getActivityIdList() {
        return activityIdList;
    }

    public void setActivityIdList(List<Long> activityIdList) {
        this.activityIdList = activityIdList;
    }
    
    public Integer getDataSource() {
        return dataSource;
    }

    
    public void setDataSource(Integer dataSource) {
        this.dataSource = dataSource;
    }
    
    public Long getDirectId() {
        return directId;
    }

    
    public void setDirectId(Long directId) {
        this.directId = directId;
    }
    
    public String getDirectName() {
        return directName;
    }

    
    public void setDirectName(String directName) {
        this.directName = directName;
    }

    public Long getTagId() {
        return tagId;
    }

    public void setTagId(Long tagId) {
        this.tagId = tagId;
    }

    public Integer getTagBlock() {
        return tagBlock;
    }

    public void setTagBlock(Integer tagBlock) {
        this.tagBlock = tagBlock;
    }

    public String getTagIds() {
        return tagIds;
    }

    public void setTagIds(String tagIds) {
        this.tagIds = tagIds;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
