package cn.com.duiba.tuia.ssp.center.api.constant;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * @author yuantong
 * 钉钉通知的moduleType
 */
public enum ModuleTypeEnum {

    TYPE_CASH_ORDER((byte) 0, "提现审核"),
    TYPE_PRE_PAY((byte) 1, "预付款"),
    TYPE_MEDIA((byte) 2, "媒体审核"),
    TYPE_REWARD((byte) 3, "激励审核"),
    TYPE_CERTIFICATION((byte) 4, "资质认证"),
    TYPE_SLOT_PROPORTION((byte) 5, "广告位分成比例"),
    TYPE_MEDIA_CONTRACT((byte) 6, "合同到期通知"),
    ALGO_MANUAL_CONTRACT((byte) 10, "算法切量人工比较");


    public static final Map<String, Byte> TAG_TYPE_MAP;

    static {
        Map<String, Byte> temp = new HashMap<>(ModuleTypeEnum.values().length, 1);
        for (ModuleTypeEnum tag: ModuleTypeEnum.values()) {
            temp.put(tag.name(), tag.getCode());
        }
        TAG_TYPE_MAP = Collections.unmodifiableMap(temp);
    }

    ModuleTypeEnum(final Byte code, final String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static Byte getByteType(String value) {
        return TAG_TYPE_MAP.get(value);
    }


    private Byte code;
    private String desc;

    public Byte getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
