package cn.com.duiba.tuia.ssp.center.api.constant;

/**
 * 微信自动推送
 *
 * @author zhangzhenghe
 * @since 2019-12-09 3:03 PM
 */
public enum WeChatAutoNoticeEnum {

    NOTICE_TYPE_SETTLEMENT(0, "结算生成"),

    NOTICE_TYPE_WITHDRAWALS(1, "提现审核"),

    NOTICE_DETAIL_TYPE_SETTLEMENT_UNSIGNED(0, "结算单已生成合同尚未签署"),

    NOTICE_DETAIL_TYPE_SETTLEMENT_WITHDRAWALS(1, "结算单已生成且提现金额满足条件（>100）"),

    NOTICE_DETAIL_TYPE_SETTLEMENT_NOT_WITHDRAWALS(2, "结算单已生成但提现金额不满足条件"),

    NOTICE_DETAIL_TYPE_WITHDRAWALS_APPLY(3, "申请提现提交成功"),

    NOTICE_DETAIL_TYPE_WITHDRAWALS_REQUIREMENT(4, "请款通过"),

    NOTICE_DETAIL_TYPE_WITHDRAWALS_FINANCIAL(5, "财务审核通过"),

    NOTICE_DETAIL_TYPE_WITHDRAWALS_TRANSFER(6, "已打款"),

    NOTICE_DETAIL_TYPE_WITHDRAWALS_REFUSE(7, "提现审核拒绝");

    private Integer type;

    private String desc;

    WeChatAutoNoticeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
