package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.DomainMaintainDetailDTO;
import cn.com.duiba.tuia.ssp.center.api.dto.DomainMaterialDTO;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.params.DomainContentGenerationQuery;

import java.util.List;

/**
 * @Author: xingbo
 * @Date: 2021/7/5
 */
@AdvancedFeignClient
public interface RemoteDomainContentGenerationService {

    /**
     * 查询需要维生成内容的域名列表
     */
    PageResultDto<DomainMaintainDetailDTO> selectDomainList(DomainContentGenerationQuery query);

    /**
     * 添加需要维生成内容的域名
     */
    void insertDomain(List<DomainMaintainDetailDTO> domainMaintainDTOList) throws BizException;

    /**
     * 删除需要维生成内容的域名
     */
    void deleteDomain(Long id);

    /**
     * 判断域名是否需要生成内容
     */
    boolean isNeedGeneration(String domainUrl);

    /**
     * 随机生成轮播图和小图
     */
    List<DomainMaterialDTO> randomGenerateDomainMaterial(DomainContentGenerationQuery query);

    /**
     * 查询域名素材列表
     * @return
     */
    PageResultDto<DomainMaterialDTO> selectDomainMaterialList(DomainContentGenerationQuery query);

    /**
     * 添加域名素材
     * @return
     */
    void insertDomainMaterial(DomainMaterialDTO domainMaterialDTO) throws BizException;

    /**
     * 删除域名素材
     * @return
     */
    void deleteDomainMaterial(Long id);

}
