package cn.com.duiba.tuia.ssp.center.api.dto.slotActivityWayGroup;

import com.google.common.base.Objects;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author yuantong
 *
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ReqSlotActivityGroup implements Serializable {

    private Long slotId;

    /** 地域类型ID */
    private Long regionId;

    /**
     * 所属组
     */
    private Byte groupSort;

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final ReqSlotActivityGroup that = (ReqSlotActivityGroup) o;
        return Objects.equal(slotId, that.slotId) &&
                Objects.equal(regionId, that.regionId) &&
                Objects.equal(groupSort, that.groupSort);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(slotId, regionId, groupSort);
    }
}