package cn.com.duiba.tuia.ssp.center.api.dto.advertisingConsumption;

import cn.com.duiba.tuia.ssp.center.api.dto.BaseDto;
import com.google.common.collect.Lists;

import java.io.Serializable;
import java.util.List;

/**
 * 广告消耗环比
 */
public class AdvertisingConsumptionDto extends BaseDto implements Serializable {

    private static final long serialVersionUID = 2801081734479552091L;

    /**
     * 广告位ID
     */
    private  Long slotId;
    /**
     * 广告位名称
     */
    private String slotName;
    /**
     * 媒体ID
     */
    private Long appId;
    /**
     * 账号ID
     */
    private Long mediaId;
    /**
     * 应得收入
     */
    private Long consumeTotal;
    /**
     * 前日收益
     */
    private Long consumeTotalDayBefore;
    /**
     * 应得收入与昨日环比
     */
    private Double consumeTotalRateYesterday;
    /**
     * 广告位点击率
     */
    private Double slotClickRate;
    /**
     * 广告位点击率与昨日环比
     */
    private Double slotClickRateYesterday;
    /**
     * 广告位访问UV
     */
    private Long slotAccessUv;
    /**
     * 广告位访问UV与昨日环比
     */
    private Double slotAccessUvRateYesterday;
    /**
     * 每UV发券
     */
    private Double uvCoupon;
    /**
     * 每UV发券与昨日环比
     */
    private Double uvCouponRateYesterday;
    /**
     * arpu值
     */
    private Double arpuVal;

    /**
     * arpu值与昨日环比
     */
    private Double arpuValRateYesterday;


    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public String getSlotName() {
        return slotName;
    }

    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public Long getConsumeTotal() {
        return consumeTotal;
    }

    public void setConsumeTotal(Long consumeTotal) {
        this.consumeTotal = consumeTotal;
    }

    public Long getConsumeTotalDayBefore() {
        return consumeTotalDayBefore;
    }

    public void setConsumeTotalDayBefore(Long consumeTotalDayBefore) {
        this.consumeTotalDayBefore = consumeTotalDayBefore;
    }

    public Double getConsumeTotalRateYesterday() {
        return consumeTotalRateYesterday;
    }

    public void setConsumeTotalRateYesterday(Double consumeTotalRateYesterday) {
        this.consumeTotalRateYesterday = consumeTotalRateYesterday;
    }

    public Double getSlotClickRate() {
        return slotClickRate;
    }

    public void setSlotClickRate(Double slotClickRate) {
        this.slotClickRate = slotClickRate;
    }

    public Double getSlotClickRateYesterday() {
        return slotClickRateYesterday;
    }

    public void setSlotClickRateYesterday(Double slotClickRateYesterday) {
        this.slotClickRateYesterday = slotClickRateYesterday;
    }

    public Long getSlotAccessUv() {
        return slotAccessUv;
    }

    public void setSlotAccessUv(Long slotAccessUv) {
        this.slotAccessUv = slotAccessUv;
    }

    public Double getSlotAccessUvRateYesterday() {
        return slotAccessUvRateYesterday;
    }

    public void setSlotAccessUvRateYesterday(Double slotAccessUvRateYesterday) {
        this.slotAccessUvRateYesterday = slotAccessUvRateYesterday;
    }

    public Double getUvCoupon() {
        return uvCoupon;
    }

    public void setUvCoupon(Double uvCoupon) {
        this.uvCoupon = uvCoupon;
    }

    public Double getUvCouponRateYesterday() {
        return uvCouponRateYesterday;
    }

    public void setUvCouponRateYesterday(Double uvCouponRateYesterday) {
        this.uvCouponRateYesterday = uvCouponRateYesterday;
    }

    public Double getArpuVal() {
        return arpuVal;
    }

    public void setArpuVal(Double arpuVal) {
        this.arpuVal = arpuVal;
    }

    public Double getArpuValRateYesterday() {
        return arpuValRateYesterday;
    }

    public void setArpuValRateYesterday(Double arpuValRateYesterday) {
        this.arpuValRateYesterday = arpuValRateYesterday;
    }

    public List<String> iniQuerytStr(){
        return Lists.newArrayList("slotClickRate","slotAccessUv","uvCoupon","arpuVal");
    }

}
