/**
 * Project Name:media-manager-biz File Name:ReqUpdateCheckStatus.java Package
 * Name:cn.com.duiba.tuia.media.manager.model.req Date:2016年12月5日下午12:46:13 Copyright (c) 2016, duiba.com.cn All Rights
 * Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName:ReqUpdateCheckStatus <br/>
 * Function: 更新审核状态. <br/>
 * Date: 2016年12月5日 下午12:46:13 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
@ApiModel
public class ReqUpdateCheckStatus implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = -6640978654611672021L;

    /** id */
    @ApiModelProperty(value = "reportId", required = true)
    @NotNull(message = "reportId不能为空")
    private Long              reportId;

    /** 应用id */
    @ApiModelProperty(value = "应用ID ", required = true)
    @NotNull(message = "应用ID不能为空")
    private Long           appId;

    /** 应用id */
    @ApiModelProperty(value = "月账单日期 ", required = true)
    @NotNull(message = "月账单日期不能为空")
    private String           currentDate;

    /** 审核状态 */
    @ApiModelProperty(value = "审核状态 ", required = true)
    @NotNull(message = "审核状态不能为空")
    private Integer           status;

    @ApiModelProperty(value = "结算状态", required = false)
    private Integer           settlementStatus;

    @ApiModelProperty(value = "结算拒绝原因", required = false)
    private String rejectReason;

    @ApiModelProperty(value = "生成日期", required = false)
    private String gmtCreate;

    @ApiModelProperty(value = "自动审核通过")
    private Integer autoClear = 0;

    /**
     * reportId.
     *
     * @return the reportId
     * @since JDK 1.6
     */
    public Long getReportId() {
        return reportId;
    }

    /**
     * reportId.
     *
     * @param reportId the reportId to set
     * @since JDK 1.6
     */
    public void setReportId(Long reportId) {
        this.reportId = reportId;
    }

    /**
     * status.
     *
     * @return the status
     * @since JDK 1.6
     */
    public Integer getStatus() {
        return status;
    }

    /**
     * status.
     *
     * @param status the status to set
     * @since JDK 1.6
     */
    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * settlementStatus.
     *
     * @return the settlementStatus
     * @since JDK 1.6
     */
    public Integer getSettlementStatus() {
        return settlementStatus;
    }

    /**
     * settlementStatus.
     *
     * @param settlementStatus the settlementStatus to set
     * @since JDK 1.6
     */
    public void setSettlementStatus(Integer settlementStatus) {
        this.settlementStatus = settlementStatus;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getCurrentDate() {
        return currentDate;
    }

    public void setCurrentDate(String currentDate) {
        this.currentDate = currentDate;
    }

    public String getRejectReason() {
        return rejectReason;
    }

    public void setRejectReason(String rejectReason) {
        this.rejectReason = rejectReason;
    }
    
    public String getGmtCreate() {
        return gmtCreate;
    }

    
    public void setGmtCreate(String gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Integer getAutoClear() {
        return autoClear;
    }

    public void setAutoClear(Integer autoClear) {
        this.autoClear = autoClear;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
