package cn.com.duiba.tuia.ssp.center.api.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Optional;

/**
 * @Author zhangliwei
 * @Description  新媒体测试黑名单返回给前端对象
 * @Date 15:38 2019-10-10
 * @Param
 * @return
 **/
@Data
@NoArgsConstructor
@AllArgsConstructor
public class NewMediaBlackListDto extends NewMediaBlackList {


    /**
     * 媒体标签
     */
    private String appTag;

    /**
     * 媒体名称
     */
    private String appName;

    /**
     * 账号名称
     **/
    private String mediaName;


    public NewMediaBlackListDto(NewMediaBlackList item, String appName, String appTag,String mediaName,Long mediaId) {
        setId(item.getId());
        setAppId(item.getAppId());
        setIdType(item.getIdType());
        setGmtCreate(item.getGmtCreate());
        setGmtModified(item.getGmtModified());
        setMediaId(mediaId);
        this.appName = Optional.ofNullable(appName).orElse("");
        this.appTag = Optional.ofNullable(appTag).orElse("");
        this.mediaName = Optional.ofNullable(mediaName).orElse("");
    }



}
