package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.PageDto;
import cn.com.duiba.tuia.ssp.center.api.dto.SlotChooseAdvertDTO;

import java.util.List;

/**
 * @Author yuquanfeng
 * @Date 2021/5/25
 * @Description
 * @Param
 * @return
 **/
@AdvancedFeignClient
public interface RemoteSlotChooseAdvertTemporaryStorage {
    /**
     * 批量添加
     * @param slotChooseAdvertDTOS 需要添加的数据
     * @return Boolean
     */
    Boolean batchAddSlotChooseAdvert(List<SlotChooseAdvertDTO> slotChooseAdvertDTOS);

    /**
     * 删除
     * @param slotChooseAdvertDTO 删除条件
     * @return Boolean
     * @throws BizException
     */
    Boolean removeSlotChooseAdvert(SlotChooseAdvertDTO slotChooseAdvertDTO) throws BizException;

    /**
     * 查询条数
     * @param slotChooseAdvertDTO 查询条件
     * @return Integer
     * @throws BizException
     */
    Integer getCount(SlotChooseAdvertDTO slotChooseAdvertDTO) throws BizException;

    /**
     * 通过条件查询
     * @param slotChooseAdvertDTO 查询条件
     * @return List<SlotChooseAdvertDTO>
     * @throws BizException
     */
    List<SlotChooseAdvertDTO> selectSlotChooseAdvertByCondition(SlotChooseAdvertDTO slotChooseAdvertDTO) throws BizException;

    /**
     * 分页查询
     * @param slotChooseAdvertDTO
     * @return
     */
    PageDto<SlotChooseAdvertDTO> pageGetChooseAdvert(SlotChooseAdvertDTO slotChooseAdvertDTO) throws BizException;
}
