package cn.com.duiba.tuia.ssp.center.api.remote.mediaTest.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 条件信息 :: 获取条件
 * @author haitao.hua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = false, chain = true, prefix = "")
public class GainCondition implements Serializable {

    private static final long serialVersionUID = -3842590088645693914L;

    /**
     * 开始时间.
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date startTime;

    /**
     * 结束时间.
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date endTime;

    /**
     * 媒体 Id
     */
    private Long appId;

    /**
     * 媒体名称
     */
    private String appName;

    /**
     * 质量等级
     */
    private String qualityLevel;

    /**
     * 测试状态 { 0: 初始状态·待测试, 1: 测试结束, 2: 测试完成, 3: 测试中 }
     */
    private Integer tesStatus;

    /**
     * 媒体 Id 集合
     */
    private List<Long> appIdSet;

    /**
     * 管理员 Id
     */
    private Long managerId;

    /**
     * 优先级  1-优先 0-普通
     **/
    private Integer priority;

    /**
     * start_date <= ?
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date leStartTestDate;

    /**
     * end_date <= ?
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date leEndTestDate;

    /**
     * id > ?
     */
    private Long gtId;

}
