/**
 * Project Name:media-api<br>
 * File Name:SlotCacheDto.java<br>
 * Package Name:cn.com.duiba.tuia.media.api.dto<br>
 * Date:2016年10月19日下午7:23:05<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;
import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: SlotCacheDto <br/>
 * Function: 屏蔽策略缓存对象. <br/>
 * date: 2016年10月19日 下午7:23:05 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class SlotCacheDto implements Serializable {

	private static final long  serialVersionUID    = 1L;

    /** 透明. */
    public static final String PICTURE_TYPE_ALPHA0 = "alpha0";

    private Long               id;

    /** 广告位类型 0-插屏 1-横幅 2-信息流 3-banner 4-浮标 5-应用墙. */
    private Integer            slotType;

    /** 主图尺寸-宽. */
    private int                pictureWidth;

    /** 主图尺寸-高. */
    private int                pictureHeight;

    /** 屏蔽策略ID. */
    private Long               strategyId;

    /** 是否有效：true：有效， false：无效(广告位审核中或者未开启). */
    private boolean            isValid;

    /** 图片类型 alpha0 透明 : */
    private String             pictureType;

    /** 活动投放目标URL */
    private String             activityTargetUrl;

    /** 小图标是否可见. */
    private boolean            isVisibleOfIco;

    /** 关闭按钮是否可见. */
    private boolean            isVisibleOfCloseButton;

    /** 广告位曝光上限 */
    private Integer            slotExposeLimit;

    /** 活动曝光上限 */
    private Integer            activityExposeLimit;

    /** 广告位关联规格列表 */
    private Long               slotMsId;

    /** 媒体APPID */
    private Long               appId;
    
    /** 是否拦截返回操作(1:拦截，0:不拦截). */
    private Boolean            isReturn;

    /** 拦截返回操作频次. */
    private Integer            numReturn;

    /** 推荐位弹层开关(1:开，0:关). */
    private Boolean            isRecommend;

    /** 广告位投放方式 */
    private Integer    		  activityPutWay;

    /**管理端屏蔽策略标签*/
    private  Long             managerStrategyId ;
    
    /** 活动客服开关(1:开，0:关). */
    private Integer            showService;

    /** 广告位额外信息 */
    private PlugBuoyConfigDto plugBuoyConfigDto;

    /** 激励开关(0-关闭，1-默认，2-自定义) */
    private Integer             incentiveSwitch;

    /** 激励活动内容配置 */
    private IncentiveContentDto incentiveContentDto;

    /** 接入广告类型 0-互动广告 1-展示广告 */
    private Integer slotAccessType;

    /** 广告位是否开启地域定向，默认0：关闭，1：打开 */
    private Integer slotRegionStatus;

    /**
     *   广告角标    tinyint  默认关闭0  , 1开启
     */
    private Integer isShowAd;

    /**
     * 承办声明开关   默认为0，1开启
     */
    private Integer undertakeStateSwitch;

    /**
     * 承办声明内容
     */
    private String undertakeStateContext;

    /** 创建时间. */
    private Date gmtCreate;

    /**
     * Creates a new instance of SlotCacheDto.
     */
    public SlotCacheDto() {
        super();
    }

    /**
     * Creates a new instance of SlotCacheDto.
     *
     * @param id the id
     */

    public SlotCacheDto(Long id) {
        super();
        this.id = id;
    }

    /**
     * Creates a new instance of SlotCacheDto.
     *
     * @param id
     * @param slotType
     * @param width
     * @param height
     * @param strategyId
     * @param pictureType
     */
    public SlotCacheDto(Long id, Integer slotType, int width, int height, Long strategyId, String pictureType) {
        super();
        this.id = id;
        this.slotType = slotType;
        this.pictureWidth = width;
        this.pictureHeight = height;
        this.strategyId = strategyId;
        this.pictureType = pictureType;
    }

    public boolean isVisibleOfIco() {
        return isVisibleOfIco;
    }

    public void setVisibleOfIco(boolean isVisibleOfIco) {
        this.isVisibleOfIco = isVisibleOfIco;
    }

    public boolean isVisibleOfCloseButton() {
        return isVisibleOfCloseButton;
    }

    public void setVisibleOfCloseButton(boolean isVisibleOfCloseButton) {
        this.isVisibleOfCloseButton = isVisibleOfCloseButton;
    }

    /**
     * pictureType.
     *
     * @return the pictureType
     * @since JDK 1.6
     */
    public String getPictureType() {
        return pictureType;
    }

    /**
     * pictureType.
     *
     * @param pictureType the pictureType to set
     * @since JDK 1.6
     */
    public void setPictureType(String pictureType) {
        this.pictureType = pictureType;
    }

    public boolean isValid() {
        return isValid;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getSlotType() {
        return slotType;
    }

    public void setSlotType(Integer slotType) {
        this.slotType = slotType;
    }

    public int getPictureWidth() {
        return pictureWidth;
    }

    public void setPictureWidth(int pictureWidth) {
        this.pictureWidth = pictureWidth;
    }

    public int getPictureHeight() {
        return pictureHeight;
    }

    public void setPictureHeight(int pictureHeight) {
        this.pictureHeight = pictureHeight;
    }

    public Long getStrategyId() {
        return strategyId;
    }

    public void setStrategyId(Long strategyId) {
        this.strategyId = strategyId;
    }

    public String getActivityTargetUrl() {
        return activityTargetUrl;
    }

    public void setActivityTargetUrl(String activityTargetUrl) {
        this.activityTargetUrl = activityTargetUrl;
    }

    public Integer getSlotExposeLimit() {
        return slotExposeLimit;
    }

    public void setSlotExposeLimit(Integer slotExposeLimit) {
        this.slotExposeLimit = slotExposeLimit;
    }

    public Integer getActivityExposeLimit() {
        return activityExposeLimit;
    }

    public void setActivityExposeLimit(Integer activityExposeLimit) {
        this.activityExposeLimit = activityExposeLimit;
    }

    public Long getSlotMsId() {
        return slotMsId;
    }

    public void setSlotMsId(Long slotMsId) {
        this.slotMsId = slotMsId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    
    public Boolean getIsReturn() {
        return isReturn;
    }

    
    public void setIsReturn(Boolean isReturn) {
        this.isReturn = isReturn;
    }

    
    public Integer getNumReturn() {
        return numReturn;
    }

    
    public void setNumReturn(Integer numReturn) {
        this.numReturn = numReturn;
    }

	public Integer getActivityPutWay() {
		return activityPutWay;
	}

	public void setActivityPutWay(Integer activityPutWay) {
		this.activityPutWay = activityPutWay;
	}


    public Boolean getIsRecommend() {
        return isRecommend;
    }

    public void setIsRecommend(Boolean isRecommend) {
        this.isRecommend = isRecommend;
    }

    public Long getManagerStrategyId() {
        return managerStrategyId;
    }

    public void setManagerStrategyId(Long managerStrategyId) {
        this.managerStrategyId = managerStrategyId;
    }
    
    public Integer getShowService() {
        return showService;
    }

    
    public void setShowService(Integer showService) {
        this.showService = showService;
    }

    public PlugBuoyConfigDto getPlugBuoyConfigDto() {
        return plugBuoyConfigDto;
    }

    public void setPlugBuoyConfigDto(PlugBuoyConfigDto plugBuoyConfigDto) {
        this.plugBuoyConfigDto = plugBuoyConfigDto;
    }

    public Integer getIncentiveSwitch() {
        return incentiveSwitch;
    }

    public void setIncentiveSwitch(Integer incentiveSwitch) {
        this.incentiveSwitch = incentiveSwitch;
    }

    public IncentiveContentDto getIncentiveContentDto() {
        return incentiveContentDto;
    }

    public void setIncentiveContentDto(IncentiveContentDto incentiveContentDto) {
        this.incentiveContentDto = incentiveContentDto;
    }

    public void setSlotAccessType(Integer slotAccessType) {
        this.slotAccessType = slotAccessType;
    }

    public Integer getSlotAccessType() {
        return slotAccessType;
    }

    public Integer getSlotRegionStatus() {
        return slotRegionStatus;
    }

    public void setSlotRegionStatus(Integer slotRegionStatus) {
        this.slotRegionStatus = slotRegionStatus;
    }

    public Integer getIsShowAd() {
        return isShowAd;
    }

    public void setIsShowAd(Integer isShowAd) {
        this.isShowAd = isShowAd;
    }

    public Integer getUndertakeStateSwitch() {
        return undertakeStateSwitch;
    }

    public void setUndertakeStateSwitch(Integer undertakeStateSwitch) {
        this.undertakeStateSwitch = undertakeStateSwitch;
    }

    public String getUndertakeStateContext() {
        return undertakeStateContext;
    }

    public void setUndertakeStateContext(String undertakeStateContext) {
        this.undertakeStateContext = undertakeStateContext;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }
}
