package cn.com.duiba.tuia.ssp.center.api.query;

import cn.com.duiba.tuia.ssp.center.api.dto.BaseQueryDto;
import lombok.Data;

import java.util.Date;

/**
 * @author K. L. Mao
 * @create 2019-12-31
 */
@Data
public class SdkCrashLogQuery extends BaseQueryDto {

    private Long id;

    private Long appId;

    private String imei;

    private String idfa;

    private String oaid;

    private String deviceId;

    private String sdkVersion;

    private String phoneBrand;

    private String phoneModel;

    // 系统版本
    private String osVersion;

    // 系统型号
    private String osType;

    // 包名
    private String packageName;

    /**
     * 处理状态
     * {@link cn.com.duiba.tuia.ssp.center.api.constant.enums.SdkCrashLogStatusEnum}
     */
    private Integer status;

    // 崩溃日志
    private String crashLogs;

    private Date gmtCreateFrom;

    private Date gmtCreateTo;

    private Date gmtModifiedFrom;

    private Date gmtModifiedTo;

    // 补丁code
    private String patchCode;

    // 补丁版本
    private String patchVersion;

    /**
     * 日志类型，安卓sdk时必传，1=安卓sdk奔溃，2=oaid崩溃，3=其他奔溃类型
     */
    private Integer logType;

}
