package cn.com.duiba.tuia.ssp.center.api.dto.sdk;

import cn.com.duiba.tuia.ssp.center.api.annotation.FieldCheck;
import cn.com.duiba.tuia.ssp.center.api.tool.DateUtil;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class SdkAggreCrashLogDTO implements Serializable {

    private String idList;

    private String sdkVersionList;

    private String patchVersionList;

    private Long pv;

    private Long uv;

    /**
     * 处理状态：1-已处理 2-未处理 3-不可处理 9-其他
     * {@link cn.com.duiba.tuia.ssp.center.api.constant.enums.SdkCrashLogStatusEnum}
     */
    private Integer status;

    private String crashLogs;

    @JsonFormat(pattern = DateUtil.DEFAULT_FORMATTER, timezone = "GMT+8")
    private Date latestReportTime;

    @JsonFormat(pattern = DateUtil.DEFAULT_FORMATTER, timezone = "GMT+8")
    private Date oldestReportTime;
}