package cn.com.duiba.tuia.ssp.center.api.remote.prePayInvoiceRecord;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.IdAndNameDto;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.remote.prePayInvoiceRecord.dto.*;
import cn.com.duiba.tuia.ssp.center.api.remote.prePayInvoiceRecord.params.*;
import java.util.List;

/**
 * { Remote } 发票记录 Service
 * @dateTime 2020-12-08 11:51:27
 * @author haitao.hua
 */
@AdvancedFeignClient
public interface RemoteInvoiceRecordService {

    /**
     * { 分页 } 发票纪录
     * @param params 参数
     * @return 处理结果
     */
    PageResultDto<InvoiceInfoDto> invoicePagination(GainInvoiceParams params);

    /**
     * { 分页 } 发票追踪
     * @param params 参数
     * @return 处理结果
     */
    PageResultDto<InvoiceTrackingDto> invoiceTrackingPagination(GainInvoiceTrackingParams params);

    /**
     * { 保存·发票 } 审核结果
     * @param params 参数
     * @return 处理结果
     */
    Boolean invoiceReview(SavingReviewResultParams params);

    /**
     * { 保存 } 流转信息
     * @param params 参数
     * @return 处理结果
     */
    Boolean savingCirculationInfo(SavingCirculationParams params);

    /**
     * 模糊匹配 { Media.Id, Media.Name } 查询信息
     * @param characters 匹配字符
     * @return 处理结果
     */
    List<IdAndNameDto> fuzzySelectInfo(String characters);

}
