package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ShareProportionAuditDTO;

import java.util.List;

/**
 * @Author yuquanfeng
 * @Date 2021/8/4
 * @Description
 * @Param
 * @return
 **/
@AdvancedFeignClient
public interface RemoteShareProportionAudiService {
    /**
     * 添加分成比例审核记录
     * @param shareProportionAuditDTO 分成比例信息
     * @return
     * @throws BizException
     */
    Boolean addShareProportionAudit(ShareProportionAuditDTO shareProportionAuditDTO) throws BizException;

    /**
     * 通过条件查询
     * @param shareProportionAuditDTO
     * @return
     * @throws BizException
     */
    List<ShareProportionAuditDTO> queryShareProportionAudit(ShareProportionAuditDTO shareProportionAuditDTO) throws BizException;

    /**
     * 分页查询
     * @param shareProportionAuditDTO
     * @return
     * @throws BizException
     */
    PageResultDto<ShareProportionAuditDTO> pageGetShareProportionAudit(ShareProportionAuditDTO shareProportionAuditDTO) throws BizException;

    /**
     * 批量审核
     * @param idList 审核记录id
     * @param auditStatus 审核状态
     * @param auditId 审核人id
     * @return
     * @throws BizException
     */
    Boolean batchAudit(List<Long> idList, Integer auditStatus, Long auditId);

    /**
     * 查询总和
     * @param shareProportionAuditDTO
     * @return
     */
    ShareProportionAuditDTO querySum(ShareProportionAuditDTO shareProportionAuditDTO);
}
