package cn.com.duiba.tuia.ssp.center.api.tool;

import cn.com.duiba.tuia.ssp.center.api.constant.SSPErrorCode;
import cn.com.duiba.tuia.ssp.center.api.dto.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author K. L. Mao
 * @create 2019-11-07
 */
public class RemoteExcuteTemplateHandle {

    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteExcuteTemplateHandle.class);

    /**
     * 回调执行方法
     *
     * @param callBack      回调实现对象参数
     * @param logger        日志参数
     * @param reqJsonString 请求参数jsonString
     * @param <T>           业务处理返回对象
     * @return 业务处理结果
     */
    public static <T> Result<T> execute(ExecuteCallBack<T> callBack, Logger logger, String reqJsonString) {
        try {
            return callBack.process();
        } catch (Exception e) {
            return handleException(e, logger, reqJsonString);
        }
    }

    /**
     * 异常处理封装,统一返回结果
     *
     * @param e             异常信息
     * @param logger        日志
     * @param reqJsonString 请求对象json
     * @return 返回异常封装业务处理结果
     */
    private static <T> Result<T> handleException(Exception e, Logger logger, String reqJsonString) {
        try {
            String message = e.getMessage();
            message = message.substring(message.indexOf("message") + 10, message.indexOf("timestamp") - 3);
            String methodName = StackTraceUtil.getCallMethodName(2);
            logger.error(methodName + " 服务调用异常，请求参数:{}, errorMsg:{}", reqJsonString, message, e);
            return Result.error(SSPErrorCode.SSP_111111.getCode(), message);
        } catch (Throwable throwable) {
            LOGGER.error("handleException throwable", e);
        }
        return Result.error(SSPErrorCode.SSP_111111);
    }
}
