package cn.com.duiba.tuia.ssp.center.api.constant.ocpx;

import lombok.Getter;

/**
 * @Author yuquanfeng
 * @Date 2022/4/11
 * @Description 媒体节点枚举
 * @Param
 * @return
 **/
@Getter
public enum MediaTypeEnum {
/************************************************快手subType类型***********************************************************************/
    KUAISHOU_PHONE(1, "1", "激活"),
    KUAISHOU_FORM(1, "2", "注册"),
    KUAISHOU_VIEW(1, "3", "付费"),
    KUAISHOU_ACTIVE(1, "5", "活跃"),
    KUAISHOU_ACTIVE_REGISTER(1, "6", "优质用户"),
    KUAISHOU_ACTIVE_PAY(1, "7", "次日留存"),
    KUAISHOU_CONSULT_EFFECTIVE(1, "9", "表单"),
    KUAISHOU_IN_APP_ORDER(1, "10", "完件"),
    KUAISHOU_IN_APP_PAY(1, "11", "授信"),
    KUAISHOU_GAME_ADDICTION(1, "44", "有效线索"),
    KUAISHOU_CUSTOMER_EFFECTIVE(1, "84", "唤起应用"),
    KUAISHOU_COUPON(1, "109", "电话卡激活"),
    KUAISHOU_NEXT_DAY_OPEN(1, "117", "意向确认"),
    KUAISHOU_SHOPPING(1, "118", "微信加粉"),
    KUAISHOU_LOAN_COMPLETION(1, "119", "成交"),

/************************************************广点通subType类型***********************************************************************/

    GAUNGDAINTONG_RESERVATION(10, "RESERVATION", "预约"),
    GAUNGDAINTONG_CONFIRM_EFFECTIVE_LEADS(10, "CONFIRM_EFFECTIVE_LEADS", "有效综合线索"),
    GAUNGDAINTONG_ACTIVATE_APP(10, "ACTIVATE_APP", "激活"),
    GAUNGDAINTONG_START_APP(10, "START_APP", "次日留存"),
    GAUNGDAINTONG_REGISTER(10, "REGISTER", "注册"),
    GAUNGDAINTONG_PURCHASE(10, "PURCHASE", "付费"),
    GAUNGDAINTONG_COMPLETE_ORDER(10, "COMPLETE_ORDER", "下单"),
    GAUNGDAINTONG_APPLY(10, "APPLY", "完件"),
    GAUNGDAINTONG_PRE_CREDIT(10, "PRE_CREDIT", "预授信"),
    GAUNGDAINTONG_CREDIT(10, "CREDIT", "授信"),


/************************************************百度subType类型***********************************************************************/

    BAIDU_CONSULT_BUTTON_CLICK(2, "1", "咨询按钮点击"),
    BAIDU_PHONE_CLICK(2, "2", "电话按钮点击"),
    BAIDU_FORM_SUBMIT(2, "3", "表单提交成功"),
    BAIDU_ACTIVATION(2, "4", "激活"),
    BAIDU_FORM_BUTTON_CLICK(2, "5", "表单按钮点击"),
    BAIDU_DOWNLOAD_BUTTON_CLICK(2, "6", "下载按钮点击"),
    BAIDU_BUY_BUTTON_CLICK(2, "7", "购买按钮点击(支付按钮点击)"),
    BAIDU_APPOINTMENT_BUTTON_CLICK(2, "12", "预约按钮点击"),
    BAIDU_SECOND_ECOMMERCE_ORDER_SUBMIT(2, "14", "二类电商订单提交成功"),
    BAIDU_SINGLE_TABLE_CALL_UP_BUTTON_CLICK(2, "16", "表单调起按钮点击"),
    BAIDU_EFFECTIVE_CLUES(2, "18", "有效线索"),
    BAIDU_APP_REGISTRATION(2, "25", "应用注册"),



/************************************************巨量subType类型***********************************************************************/
    JULIANG_PHONE(8, "phone", "电话拨打"),
    JULIANG_FORM(8, "form", "表单提交"),
    JULIANG_VIEW(8, "view", "关键页面浏览"),
    JULIANG_ACTIVE(8, "active", "激活"),
    JULIANG_ACTIVE_REGISTER(8, "active_register", "注册"),
    JULIANG_ACTIVE_PAY(8, "active_pay", "付费"),
    JULIANG_CONSULT_EFFECTIVE(8, "consult_effective", "有效咨询"),
    JULIANG_IN_APP_ORDER(8, "in_app_order", "app内下单"),
    JULIANG_IN_APP_PAY(8, "in_app_pay", "app内付费"),
    JULIANG_GAME_ADDICTION(8, "game_addiction", "关键行为"),
    JULIANG_CUSTOMER_EFFECTIVE(8, "customer_effective", "有效获客"),
    JULIANG_COUPON(8, "coupon", "卡券领取"),
    JULIANG_NEXT_DAY_OPEN(8, "next_day_open", "次留"),
    JULIANG_SHOPPING(8, "shopping", "商品购买"),
    JULIANG_LOAN_COMPLETION(8, "loan_completion", "完件"),
    JULIANG_LOAN_CREDIT(8, "loan_credit", "授信"),
    JULIANG_CLUE_FORMAL_ORDER(8, "clue_formal_order", "线索-正式成单"),
    JULIANG_SUPPLY_ACTIVE_PAY(8, "supply_active_pay", "付费-新"),


/************************************************趣头条subType类型***********************************************************************/
    QUTOUTIAO_SUBMIT_FORM(3, "26", "提交表单"),
    QUTOUTIAO_PAY(3, "31", "表单付费"),
    QUTOUTIAO_OTHERS(3, "27", "其他"),
    QUTOUTIAO_CONSULATION(3, "28", "有效咨询"),
    QUTOUTIAO_LANDING_PAGE_JUMP(3, "29", "落地页跳转"),


/************************************************喜马拉雅subType类型***********************************************************************/
    XIMALAYA_SUBMIT_FORM(17, "2", "表单提交"),
    XIMALAYA_PAY(17, "7", "支付-存在意向"),
    XIMALAYA_VISIT(17, "8", "回访-信息确认"),
    XIMALAYA_CONSULATION(17, "3", "有效咨询"),
    XIMALAYA_OTHERS(17, "6", "其他"),


/************************************************爱奇艺subType类型***********************************************************************/
    IQIYI_SUBMIT_FORM(4, "200", "表单提交"),
    IQIYI_DETAIL(4, "201", "查看详情"),
    IQIYI_CREDIT(4, "210", "授信"),


/************************************************B站subType类型***********************************************************************/
    BLIBLI_APP_DOWNLOAD(9, "APP_DOWNLOAD", "APP下载成功"),
    BLIBLI_APP_INSTALL(9, "APP_INSTALL", "APP安装成功"),
    BLIBLI_APP_FIRST_ACTIVE(9, "APP_FIRST_ACTIVE", "APP首次激活"),
    BLIBLI_FORM_SUBMIT(9, "FORM_SUBMIT", "表单提交"),
    BLIBLI_USER_REGISTER(9, "USER_REGISTER", "用户注册"),
    BLIBLI_ADD_TO_CART(9, "ADD_TO_CART", "加入购物车"),
    BLIBLI_ORDER_PLACE(9, "ORDER_PLACE", "提交订单"),
    BLIBLI_USER_COST(9, "USER_COST", "完成付费行为"),
    BLIBLI_USER_RESERVE(9, "USER_RESERVE", "用户参与某个活动预订"),
    BLIBLI_RETENTION(9, "RETENTION", "用户留存"),
    BLIBLI_APP_CALLUP(9, "APP_CALLUP", "调起成功"),
    BLIBLI_FORM_USER_COST(9, "FORM_USER_COST", "教育完成表单付费行为"),


/************************************************VIVO subType类型***********************************************************************/
    VIVO_ACTIVATION(15, "ACTIVATION", "激活"),
    VIVO_REGISTER(15, "REGISTER", "注册"),
    VIVO_PAY(15, "PAY", "付费"),
    VIVO_SUBMIT(15, "SUBMIT", "表单提交"),
    VIVO_WEBPAY(15, "WEBPAY", "网页购买"),
    VIVO_RETENTION_1(15, "RETENTION_1", "次日留存"),
    VIVO_CALL(15, "CALL", "拨打电话"),
    VIVO_REACTIVATION(15, "REACTIVATION", "拉活"),
    VIVO_ADD_SCREEN(15, "ADD_SCREEN", "快应用加桌"),
    VIVO_BUTTON_CLICK(15, "BUTTON_CLICK", "按钮点击"),
    VIVO_OTHER(15, "OTHER", "其他"),


/************************************************UC subType类型***********************************************************************/
    UC_ACTIVATION(16, "1", "激活"),
    UC_REGISTER(16, "27", "注册"),
    UC_ORDER(16, "11", "下单购买"),
    UC_PAY(16, "1000", "付费"),
    UC_RETENTION(16, "1001", "次日留存"),
    UC_WECHAT_FOCUS(16, "65", "微信关注"),
    UC_WECHAT_PAY(16, "66", "微信付费"),
    UC_ADD_SCREEN(16, "68", "快应用加桌"),
    UC_PAY_SCREEN(16, "69", "快应用付费"),
    UC_CALL_UP(16, "50", "调起"),
    UC_VISIT_PRODUCT_DETAILS(16, "51", "访问商品详情"),


/************************************************wifi万能钥匙 subType类型***********************************************************************/
    WN_WIFI_ACTIVATION(18, "1", "激活事件"),
    WN_WIFI_REGISTER(18, "2", "注册事件"),
    WN_WIFI_PAY(18, "3", "付费事件"),
    WN_WIFI_RETENTION(18, "5", "次日留存"),
    WN_WIFI_ADDICTION(18, "6", "关键行为"),
    WN_WIFI_18DAY_REACTIVATION(18, "7", "18天拉活"),
    WN_WIFI_30DAY_REACTIVATION(18, "8", "30天拉活"),


    /************************************************360 subType类型***********************************************************************/
    API360_SUBMIT(19, "SUBMIT", "表单提交"),
    API360_CALL(19, "CALL", "电话拨打"),
    API360_ADVISORY(19, "ADVISORY", "咨询"),

    /************************************************soul subType类型***********************************************************************/
    FORM_SUBMIT(20, "form", "表单提交"),
    SHOPPING(20, "shopping", "商品购买"),
    CONSULT_EFFECTIVE(20, "consult_effective", "有效咨询"),
    CUSTOMER_EFFECTIVE(20, "customer_effective", "有效获客"),
    PHONE(20, "phone", "电话拨打"),
    PAGE_VIEW(20, "page_view", "页面访问"),
    OTHER_H5(20, "other_h5", "落地页-其他"),
    ACTIVE_PAY_H5(20, "active_pay_h5", "付费-落地页"),
    GAME_ADDICTION_H5(20, "game_addiction_h5", "关键行为-落地页"),
    CLUE_FORMAL_ORDER(20, "clue_formal_order", "线索-正式成单"),
    ;
    private Integer platform;

    private String mediaType;

    private String desc;

    MediaTypeEnum(Integer platform, String mediaType, String desc){
        this.platform = platform;
        this.mediaType = mediaType;
        this.desc = desc;
    }
}
